/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.ads;

import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

public class DNALinkResultCacheManager {
    private final long adCacheTimeLimitMs;
    private boolean isRedirectionActive = false;
    private final ConcurrentHashMap<String, CacheLinkResult> linkResultCache = new ConcurrentHashMap();

    public DNALinkResultCacheManager(long adCacheTimeLimitMs) {
        this.adCacheTimeLimitMs = adCacheTimeLimitMs;
    }

    public synchronized void setRedirectionActive(boolean isActive) {
        this.isRedirectionActive = isActive;
    }

    public synchronized boolean isRedirectionActive() {
        return this.isRedirectionActive;
    }

    public CacheLinkResult getLinkResultCache(String adId) {
        CacheLinkResult item = this.linkResultCache.get(adId);
        if (item != null && item.isExpired()) {
            this.linkResultCache.remove(adId);
            return null;
        }
        if (item != null && !item.isExpired()) {
            return item;
        }
        return null;
    }

    public void setLinkResultCache(String adId, String finalUrl, JSONObject lastStatsMetadata) {
        this.cleanupExpiredItems(this.linkResultCache);
        CacheLinkResult item = new CacheLinkResult(finalUrl, lastStatsMetadata, this.adCacheTimeLimitMs);
        this.linkResultCache.put(adId, item);
    }

    private void cleanupExpiredItems(ConcurrentHashMap<String, CacheLinkResult> cache) {
        cache.entrySet().removeIf(entry -> ((CacheLinkResult)entry.getValue()).isExpired());
    }

    public static class CacheLinkResult {
        private final long cacheTimeLimitMs;
        private final long lastLoadTime;
        private final String finalUrl;
        private JSONObject lastStatsMetadata;

        public CacheLinkResult(String finalUrl, JSONObject lastStatsMetadata, long cacheTimeLimitMs) {
            this.cacheTimeLimitMs = cacheTimeLimitMs;
            this.lastLoadTime = System.currentTimeMillis();
            this.finalUrl = finalUrl;
            this.lastStatsMetadata = lastStatsMetadata;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.lastLoadTime > this.cacheTimeLimitMs;
        }

        public String getFinalUrl() {
            return this.finalUrl;
        }

        public JSONObject getLastStatsMetadata() {
            return this.lastStatsMetadata;
        }
    }
}

