package com.devicenative.dna.network;

import android.content.Context;

import com.devicenative.dna.utils.DNAError;
import com.devicenative.dna.utils.DNALogger;

import org.json.JSONObject;

public class DNAStatSyncExecutor {
    private DNANetworkRequestStats requestStats;

    public DNAStatSyncExecutor(Context context) {
        this.requestStats = new DNANetworkRequestStats(context);
    }

    public void execute() {
        long start = System.currentTimeMillis();

        requestStats.onPreExecute();

        DNANetworkInterfaceHTTPConnection httpConn = new DNANetworkInterfaceHTTPConnection();
        DNANetworkResponse response = httpConn.executePost(requestStats.getPost(), requestStats.getRequestUrl());

        if (response.getStatusCode() == 200) {
            try {
                JSONObject body = response.getBody();
                if (body.has("success") && !body.getBoolean("success")) {
                    requestStats.handleFailure(DNAError.ERR_DNA_INVALID_REQUEST, body.getString("message"));
                } else {
                    requestStats.onRequestSucceeded(response);
                }
            } catch (Exception e) {
                DNALogger.e("DNAServerPOSTLoader: " + e.getMessage());
                requestStats.handleFailure(DNAError.ERR_DNA_INVALID_REQUEST, "No success or message fields in response. Something went wrong on the server.");
            }
        } else {
            requestStats.handleFailure(response.getStatusCode(), response.getMessage());
        }

        long end = System.currentTimeMillis();
        DNALogger.i("DNAStatSyncExecutor: " + (end - start) + " milliseconds to complete network request");
    }
}
