package com.devicenative.dna.db;

import android.content.Context;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;

public class DNADatabaseQueue {
    private static final ReentrantLock MUTEX = new ReentrantLock(true);

    private static final ExecutorService SERIAL_EXEC =
            Executors.newSingleThreadExecutor(r -> {
                Thread t = new Thread(r, "dna-app-sync");
                t.setPriority((Thread.MAX_PRIORITY));
                return t;
            });

    public static void enqueue(Context ctx, Runnable r) {
        SERIAL_EXEC.execute(() -> {
            MUTEX.lock();
            try {
                r.run();
            } finally {
                MUTEX.unlock();
            }
        });
    }
}
