package com.devicenative.dna.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.UserHandle;

import com.devicenative.dna.DNADataOrchestrator;
import com.devicenative.dna.DeviceNativeAds;
import com.devicenative.dna.ads.DNAAppSearchFallback;
import com.devicenative.dna.db.DNADatabaseInterface;
import com.devicenative.dna.utils.DNALogger;
import com.devicenative.dna.utils.DNAPreferences;

public class DNAProfileChangeReceiver extends BroadcastReceiver {

    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        
        // Check if this is a relevant user/profile change event
        if (Intent.ACTION_MANAGED_PROFILE_ADDED.equals(action) ||
                Intent.ACTION_MANAGED_PROFILE_REMOVED.equals(action) ||
                Intent.ACTION_MANAGED_PROFILE_AVAILABLE.equals(action) ||
                Intent.ACTION_MANAGED_PROFILE_UNAVAILABLE.equals(action) ||
                Intent.ACTION_USER_UNLOCKED.equals(action)) {

            DNALogger.i("DNAProfileChangeReceiver: " + action + " at " + System.currentTimeMillis());
            
            // Log additional details for profile events
            if (action.contains("MANAGED_PROFILE")) {
                UserHandle user = intent.getParcelableExtra(Intent.EXTRA_USER);
                if (user != null) {
                    DNALogger.i("DNAProfileChangeReceiver: User handle: " + user.toString());
                }
            }

            // Clear all data and trigger reload for any user/profile change
            DNADatabaseInterface.removeAllShortcuts(context);
            DNAPreferences prefs = DNAPreferences.getInstance(context);
            prefs.setAppsNeedReload();
            
            // Trigger immediate reload instead of waiting for next wake
            DNAPackageChangedReceiver.triggerImmediateReload(context);

            DNAAppSearchFallback.clearCache();
        }
    }

    public void register(Context context) {
        IntentFilter filter = new IntentFilter();
        
        // Managed profile events (publicly available)
        filter.addAction(Intent.ACTION_MANAGED_PROFILE_ADDED);
        filter.addAction(Intent.ACTION_MANAGED_PROFILE_REMOVED);
        filter.addAction(Intent.ACTION_MANAGED_PROFILE_AVAILABLE);
        filter.addAction(Intent.ACTION_MANAGED_PROFILE_UNAVAILABLE);
        
        // User unlock events
        filter.addAction(Intent.ACTION_USER_UNLOCKED);

        context.registerReceiver(this, filter);
    }
}
