/*
 * Decompiled with CFR 0.152.
 */
package com.develouz.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.DownloadListener;
import android.webkit.WebBackForwardList;
import android.webkit.WebChromeClient;
import android.webkit.WebHistoryItem;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.develouz.data.b.b;
import com.develouz.lib.R;
import com.develouz.sdk.Helper;
import com.develouz.sdk.Theme;
import com.develouz.sdk.ZipArchive;
import com.develouz.view.ViewDesignAd;
import java.io.File;

public class WebBrowser
extends ViewDesignAd {
    private DevelouzView a;
    private DevelouzData b;
    private a c;

    public WebBrowser(Context context) {
        super(context);
    }

    public WebBrowser(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public WebBrowser(Context context, int style) {
        super(context, style);
    }

    @Override
    protected void initialize(AttributeSet attrs, int style) {
        super.initialize(attrs, style);
        this.a = new DevelouzView(this);
        this.b = new DevelouzData(this, attrs, style);
        this.c = new a(this);
    }

    public DevelouzView view() {
        return this.a;
    }

    public DevelouzData data() {
        return this.b;
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        RelativeLayout relativeLayout = new RelativeLayout(this.getContext());
        this.getFrame().addView((View)relativeLayout);
        relativeLayout.addView((View)this.a.c, -1, -1);
        relativeLayout.addView(this.a.d, -1, Helper.dpToPx(this.getContext(), 2));
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(13);
        relativeLayout.addView((View)this.a.e, (ViewGroup.LayoutParams)layoutParams);
        this.a.c.addView((View)this.a.b, -1, -1);
        this.a.c.setColorSchemeColors(new int[]{Theme.getColorAccent(this.getContext())});
        this.a.c.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this.b.h);
        this.a.b.setDownloadListener((DownloadListener)this.c);
        this.a.b.getSettings().setJavaScriptEnabled(true);
        this.a.b.getSettings().setDomStorageEnabled(true);
        this.a.d.setBackgroundColor(Theme.getColorAccent(this.getContext()));
        this.a.e.addView((View)this.a.f);
        this.a.e.addView((View)this.a.g);
        this.a.e.setVisibility(8);
        this.a.e.setGravity(17);
        this.a.e.setOrientation(1);
        int n = Helper.dpToPx(this.getContext(), 10);
        this.a.f.setPadding(n, n, n, n);
        this.a.f.setGravity(17);
        this.a.g.setImageResource(R.drawable.webbrowser_reload);
        this.a.g.setColorFilter(Theme.getColorText(this.getContext()));
        if (this.b.c != null) {
            ZipArchive.clone(this.getContext(), this.b.c, (ZipArchive.Callback)this.c);
        } else if (this.b.d != 0) {
            ZipArchive.clone(this.getContext(), this.b.d, (ZipArchive.Callback)this.c);
        }
    }

    @Override
    public boolean onBackPressed() {
        if (this.b.canGoBack()) {
            this.b.goBack();
            return true;
        }
        return super.onBackPressed();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.a.b.destroy();
    }

    private static class a
    implements DownloadListener,
    ZipArchive.Callback {
        private WebBrowser a;

        public a(WebBrowser webBrowser) {
            this.a = webBrowser;
        }

        public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            this.a.getContext().startActivity(intent);
        }

        @Override
        public void onSuccess(ZipArchive zip) {
            this.a.b.e = zip;
            this.a.a.b.loadUrl(zip.translateZipUrl(this.a.b.f));
        }

        @Override
        public void onProgress(int progress) {
            this.a.b.i.onProgressChanged(this.a.a.b, progress);
        }

        @Override
        @SuppressLint(value={"SetTextI18n"})
        public void onError(Exception e2) {
            this.a.b.g = true;
            this.a.a.f.setText((CharSequence)("ERROR\n" + e2.getMessage()));
            this.a.a.b.setVisibility(8);
            this.a.a.e.setVisibility(0);
            this.a.a.g.setVisibility(8);
        }
    }

    public static class DevelouzData
    extends com.develouz.data.DevelouzData {
        private WebBrowser a;
        private Context b;
        private File c;
        private int d;
        private ZipArchive e;
        private String f;
        private boolean g;
        private b h;
        private com.develouz.data.b.a i;

        private DevelouzData(WebBrowser app, AttributeSet attrs, int style) {
            this.a = app;
            this.b = app.getContext();
            this.h = new b(app);
            this.i = new com.develouz.data.b.a(app);
            this.a.a.b.setWebViewClient((WebViewClient)this.h);
            this.a.a.b.setWebChromeClient((WebChromeClient)this.i);
            if (Theme.available(attrs, style)) {
                this.setXml(attrs, style);
            }
        }

        public void setXml(AttributeSet attrs, int style) {
            Theme theme = new Theme(this.b, attrs, style, R.styleable.WebBrowser, R.styleable.WebBrowser_webBrowser);
            if (theme.hasValue(R.styleable.WebBrowser_url)) {
                this.loadUrl(theme.getString(R.styleable.WebBrowser_url));
            }
            if (theme.hasValue(R.styleable.WebBrowser_zip)) {
                this.loadZip(theme.getResourceId(R.styleable.WebBrowser_zip, 0));
            }
            this.setJavaScript(theme.getBoolean(R.styleable.WebBrowser_javaScript, true));
            this.setLangAuthRequired(theme.getString(R.styleable.WebBrowser_langAuthRequired, this.b.getString(R.string.web_browser_auth_required)));
            this.setLangLogin(theme.getString(R.styleable.WebBrowser_langLogin, this.b.getString(R.string.web_browser_login)));
            this.setLangUsername(theme.getString(R.styleable.WebBrowser_langUsername, this.b.getString(R.string.web_browser_username)));
            this.setLangPassword(theme.getString(R.styleable.WebBrowser_langPassword, this.b.getString(R.string.web_browser_password)));
            theme.recycle();
        }

        public void loadZip(File zipFile) {
            this.c = zipFile;
        }

        public void loadZip(int resId) {
            this.d = resId;
        }

        public void loadUrl(String url) {
            this.f = url;
            if (ZipArchive.isZipUrl(url) && this.e == null) {
                return;
            }
            this.a.a.b.loadUrl(url);
        }

        public boolean isHomePage() {
            String string2 = this.a.a.b.copyBackForwardList().getItemAtIndex(0).getUrl();
            String string3 = this.a.a.b.getUrl();
            return string2 != null && string2.equals(string3);
        }

        public boolean isError() {
            return this.g || this.h.a();
        }

        public WebViewClient getWebViewClient() {
            return this.h;
        }

        public WebChromeClient getWebChromeClient() {
            return this.i;
        }

        public boolean canGoBack() {
            WebBackForwardList webBackForwardList = this.a.a.b.copyBackForwardList();
            if (webBackForwardList == null || webBackForwardList.getSize() == 0) {
                return false;
            }
            WebHistoryItem webHistoryItem = webBackForwardList.getItemAtIndex(0);
            return webHistoryItem != null && !webHistoryItem.getUrl().equals(this.a.a.b.getUrl()) && !webHistoryItem.getOriginalUrl().equals(this.a.a.b.getOriginalUrl()) && this.a.a.b.canGoBack();
        }

        public ZipArchive getZipArchive() {
            return this.e;
        }

        public boolean canGoForward() {
            return this.a.a.b.canGoForward();
        }

        public void goBack() {
            this.a.a.b.goBack();
        }

        public void goForward() {
            this.a.a.b.goForward();
        }

        public void setJavaScript(boolean javaScript) {
            this.a.a.b.getSettings().setJavaScriptEnabled(javaScript);
        }

        public void setLangAuthRequired(String langAuthRequired) {
            this.h.a(langAuthRequired);
        }

        public void setLangLogin(String langLogin) {
            this.h.d(langLogin);
        }

        public void setLangUsername(String langUsername) {
            this.h.b(langUsername);
        }

        public void setLangPassword(String langPassword) {
            this.h.c(langPassword);
        }
    }

    public static class DevelouzView
    extends com.develouz.view.DevelouzView {
        private Context a;
        private WebView b;
        private SwipeRefreshLayout c;
        private View d;
        private LinearLayout e;
        private TextView f;
        private ImageButton g;

        private DevelouzView(WebBrowser app) {
            this.a = app.getContext();
            this.b = new WebView(this.a);
            this.c = new SwipeRefreshLayout(this.a);
            this.d = new View(this.a);
            this.e = new LinearLayout(this.a);
            this.f = new TextView(this.a);
            this.g = new ImageButton(this.a);
        }

        public WebView getWebView() {
            return this.b;
        }

        public SwipeRefreshLayout getRefresh() {
            return this.c;
        }

        public View getProgress() {
            return this.d;
        }

        public LinearLayout getErrorWrapper() {
            return this.e;
        }

        public TextView getErrorMessage() {
            return this.f;
        }

        public ImageButton getReload() {
            return this.g;
        }
    }
}

