/*
 * Decompiled with CFR 0.152.
 */
package com.develouz.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.widget.RelativeLayout;

public abstract class ViewDesign
extends RelativeLayout {
    public ViewDesign(Context context) {
        super(context);
        this.initialize(null, 0);
    }

    public ViewDesign(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(attrs, 0);
    }

    public ViewDesign(Context context, int style) {
        super(context);
        this.initialize(null, style);
    }

    protected abstract void initialize(AttributeSet var1, int var2);

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.onCreate();
    }

    protected void onCreate() {
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            this.onResume();
        } else {
            this.onPause();
        }
    }

    protected void onResume() {
    }

    protected void onPause() {
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return keyCode == 4 && this.onBackPressed() || super.onKeyDown(keyCode, event);
    }

    public boolean onBackPressed() {
        return false;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.onDestroy();
    }

    protected void onDestroy() {
    }
}

