/*
 * Decompiled with CFR 0.152.
 */
package com.develouz.sdk;

import android.content.Context;
import android.os.AsyncTask;
import com.develouz.sdk.FileUtils;
import com.develouz.sdk.RawStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipArchive {
    private File a;
    private static a b;

    private ZipArchive(File output) {
        this.a = output;
    }

    public static void clone(Context context, int resId, Callback callback) {
        ZipArchive.clone(context, resId, null, callback);
    }

    public static void clone(Context context, int resId, File output, Callback callback) {
        String string2 = context.getResources().getResourceEntryName(resId);
        RawStream rawStream = new RawStream(context, resId);
        ZipArchive.a(context, string2, rawStream, output, callback);
    }

    public static void clone(Context context, File zipFile, Callback callback) {
        ZipArchive.clone(context, zipFile, null, callback);
    }

    public static void clone(Context context, File zipFile, File output, Callback callback) {
        FileInputStream fileInputStream;
        String string2 = zipFile.getName();
        try {
            fileInputStream = new FileInputStream(zipFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            callback.onError(fileNotFoundException);
            return;
        }
        ZipArchive.a(context, string2, fileInputStream, output, callback);
    }

    private static void a(Context context, String string2, InputStream inputStream, File file, Callback callback) {
        String[] stringArray;
        int n;
        try {
            n = inputStream.available();
        }
        catch (IOException iOException) {
            callback.onError(iOException);
            return;
        }
        File file2 = new File(context.getFilesDir(), string2 + "." + n);
        if (file == null) {
            file = file2;
        }
        if ((stringArray = file.list()) != null && stringArray.length > 0) {
            callback.onProgress(100);
            callback.onSuccess(new ZipArchive(file));
        } else {
            if (b != null) {
                b.cancel(true);
                b = null;
            }
            b = new a(inputStream, file, callback);
            b.execute(new Void[0]);
        }
    }

    public File getOutput() {
        return this.a;
    }

    public String getOutputPath() {
        return this.a.getAbsolutePath();
    }

    public static boolean isZipUrl(String url) {
        try {
            return url.toLowerCase().startsWith("zip:");
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public String translateZipUrl(String url) {
        try {
            String string2 = "zip:///";
            if (url.toLowerCase().startsWith(string2)) {
                return url.replace(string2, "file://" + this.getOutputPath() + "/");
            }
            String string3 = "zip://";
            if (url.toLowerCase().startsWith(string3)) {
                return url.replace(string3, "file://" + this.getOutputPath() + "/");
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public static interface Callback {
        public void onSuccess(ZipArchive var1);

        public void onProgress(int var1);

        public void onError(Exception var1);
    }

    private static class a
    extends AsyncTask<Void, Object, ZipArchive> {
        private final InputStream a;
        private final File b;
        private final Callback c;
        private int d;

        a(InputStream inputStream, File file, Callback callback) {
            this.a = inputStream;
            this.b = file;
            this.c = callback;
        }

        private void a(int n, int n2) {
            int n3 = 100 * (n2 - n) / n2;
            if (n3 == this.d) {
                return;
            }
            this.d = n3;
            this.publishProgress(new Object[]{this.d});
        }

        protected void onProgressUpdate(Object ... values) {
            super.onProgressUpdate(values);
            if (values[0] instanceof Exception) {
                this.c.onError((Exception)values[0]);
            } else {
                this.c.onProgress((Integer)values[0]);
            }
        }

        protected ZipArchive a(Void ... voidArray) {
            try {
                if (this.a instanceof RawStream) {
                    ((RawStream)this.a).initialize();
                }
                int n = this.a.available();
                ZipInputStream zipInputStream = new ZipInputStream(this.a);
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                byte[] byArray = new byte[4096];
                while (zipEntry != null) {
                    File file = new File(this.b, zipEntry.getName());
                    if (!zipEntry.isDirectory()) {
                        int n2;
                        file.getParentFile().mkdirs();
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        while ((n2 = zipInputStream.read(byArray)) > 0) {
                            fileOutputStream.write(byArray, 0, n2);
                        }
                        fileOutputStream.close();
                    }
                    zipInputStream.closeEntry();
                    this.a(this.a.available(), n);
                    if (this.isCancelled()) {
                        FileUtils.delete(this.b);
                        break;
                    }
                    zipEntry = zipInputStream.getNextEntry();
                }
                zipInputStream.closeEntry();
                zipInputStream.close();
                this.a(n, n);
                return new ZipArchive(this.b);
            }
            catch (Exception exception) {
                FileUtils.delete(this.b);
                this.publishProgress(new Object[]{exception});
                exception.printStackTrace();
                return null;
            }
        }

        protected void a(ZipArchive zipArchive) {
            super.onPostExecute((Object)zipArchive);
            if (zipArchive != null) {
                this.c.onSuccess(zipArchive);
            }
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.a((ZipArchive)object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((Void[])objectArray);
        }
    }
}

