/*
 * Decompiled with CFR 0.152.
 */
package com.develouz.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import androidx.annotation.StyleableRes;
import androidx.core.content.ContextCompat;
import com.develouz.lib.R;
import com.develouz.sdk.Helper;

public class Theme {
    private final Context a;
    private final TypedArray b;
    private final TypedArray c;

    public Theme(Context context, AttributeSet attrs, int style, int[] styleables, int styleable2) {
        this.a = context;
        TypedArray typedArray = attrs != null ? context.obtainStyledAttributes(attrs, styleables) : (style != 0 ? context.obtainStyledAttributes(style, styleables) : context.obtainStyledAttributes(styleables));
        int n = typedArray.getResourceId(styleable2, 0);
        TypedArray typedArray2 = n != 0 ? context.obtainStyledAttributes(n, styleables) : typedArray;
        this.b = typedArray;
        this.c = typedArray2;
    }

    public static boolean available(AttributeSet attrs, int defStyle) {
        return attrs != null || defStyle != 0;
    }

    public static TypedValue getAttribute(Context context, int attrId) {
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(attrId, typedValue, true);
        return typedValue;
    }

    public static Drawable getDrawable(Context context, int attrId) {
        return ContextCompat.getDrawable((Context)context, (int)Theme.getAttribute((Context)context, (int)attrId).resourceId);
    }

    public static int getColorPrimary(Context context) {
        return Theme.getAttribute((Context)context, (int)R.attr.colorPrimary).data;
    }

    public static int getColorPrimaryDark(Context context) {
        return Theme.getAttribute((Context)context, (int)R.attr.colorPrimaryDark).data;
    }

    public static int getColorAccent(Context context) {
        return Theme.getAttribute((Context)context, (int)R.attr.colorAccent).data;
    }

    public static int getColorText(Context context) {
        return new TextView(context).getCurrentTextColor();
    }

    public static int getColorTheme(Context context) {
        return Theme.isLightTheme(context) ? -1 : -16777216;
    }

    public static boolean isLightTheme(Context context) {
        int n = Theme.getAttribute((Context)context, (int)0x1010031).data;
        double d2 = 1.0 - (0.299 * (double)Color.red((int)n) + 0.587 * (double)Color.green((int)n) + 0.114 * (double)Color.blue((int)n)) / 255.0;
        return d2 < 0.5;
    }

    public static CharSequence colorTextSearch(Context context, String text, String search) {
        if (Helper.empty(text) || Helper.empty(search)) {
            return text;
        }
        SpannableString spannableString = new SpannableString((CharSequence)text);
        String string2 = text.toLowerCase();
        for (String string3 : search.toLowerCase().split(" ")) {
            int n = string2.indexOf(string3);
            while (n >= 0) {
                int n2 = n + string3.length();
                spannableString.setSpan((Object)new ForegroundColorSpan(Theme.getColorAccent(context)), n, n2, 33);
                n = string2.indexOf(string3, n2);
            }
        }
        return spannableString;
    }

    public TypedArray obtainTypedArray(int index, int defValue) {
        return this.a.getResources().obtainTypedArray(this.getResourceId(index, defValue));
    }

    public CharSequence getText(@StyleableRes int index) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.getText(index) : this.c.getText(index);
    }

    @Nullable
    public String getString(@StyleableRes int index) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.getString(index) : this.c.getString(index);
    }

    @Nullable
    public String getString(@StyleableRes int index, String defValue) {
        String string2 = this.getString(index);
        if (string2 != null) {
            return string2;
        }
        return defValue;
    }

    public String getNonResourceString(@StyleableRes int index) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.getNonResourceString(index) : this.c.getNonResourceString(index);
    }

    public boolean getBoolean(@StyleableRes int index, boolean defValue) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.getBoolean(index, defValue) : this.c.getBoolean(index, defValue);
    }

    public int getInt(@StyleableRes int index, int defValue) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.getInt(index, defValue) : this.c.getInt(index, defValue);
    }

    public float getFloat(@StyleableRes int index, float defValue) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.getFloat(index, defValue) : this.c.getFloat(index, defValue);
    }

    public int getColor(@StyleableRes int index, @ColorInt int defValue) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.getColor(index, defValue) : this.c.getColor(index, defValue);
    }

    @Nullable
    public ColorStateList getColorStateList(@StyleableRes int index) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.getColorStateList(index) : this.c.getColorStateList(index);
    }

    public int getInteger(@StyleableRes int index, int defValue) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.getInteger(index, defValue) : this.c.getInteger(index, defValue);
    }

    public float getDimension(@StyleableRes int index, @SuppressLint(value={"SupportAnnotationUsage"}) @Px float defValue) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.getDimension(index, defValue) : this.c.getDimension(index, defValue);
    }

    public int getDimensionPixelOffset(@StyleableRes int index, @Px int defValue) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.getDimensionPixelOffset(index, defValue) : this.c.getDimensionPixelOffset(index, defValue);
    }

    public int getDimensionPixelSize(@StyleableRes int index, @Px int defValue) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.getDimensionPixelSize(index, defValue) : this.c.getDimensionPixelSize(index, defValue);
    }

    public int getLayoutDimension(@StyleableRes int index, String name) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.getLayoutDimension(index, name) : this.c.getLayoutDimension(index, name);
    }

    public int getLayoutDimension(@StyleableRes int index, @Px int defValue) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.getLayoutDimension(index, defValue) : this.c.getLayoutDimension(index, defValue);
    }

    public float getFraction(@StyleableRes int index, int base, int pbase, float defValue) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.getFraction(index, base, pbase, defValue) : this.c.getFraction(index, base, pbase, defValue);
    }

    public int getResourceId(@StyleableRes int index, int defValue) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.getResourceId(index, defValue) : this.c.getResourceId(index, defValue);
    }

    @Nullable
    public Drawable getDrawable(@StyleableRes int index) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.getDrawable(index) : this.c.getDrawable(index);
    }

    @RequiresApi(api=26)
    public Typeface getFont(int index) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.getFont(index) : this.c.getFont(index);
    }

    public CharSequence[] getTextArray(@StyleableRes int index) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.getTextArray(index) : this.c.getTextArray(index);
    }

    public boolean getValue(@StyleableRes int index, TypedValue outValue) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.getValue(index, outValue) : this.c.getValue(index, outValue);
    }

    @RequiresApi(api=21)
    public int getType(@StyleableRes int index) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.getType(index) : this.c.getType(index);
    }

    public boolean hasValue(@StyleableRes int index) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.hasValue(index) : this.c.hasValue(index);
    }

    @RequiresApi(api=22)
    public boolean hasValueOrEmpty(@StyleableRes int index) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.hasValueOrEmpty(index) : this.c.hasValueOrEmpty(index);
    }

    public TypedValue peekValue(@StyleableRes int index) {
        return this.b.hasValue(index) || this.b.equals(this.c) ? this.b.peekValue(index) : this.c.peekValue(index);
    }

    public void recycle() {
        if (!this.b.equals(this.c)) {
            this.b.recycle();
        }
        this.c.recycle();
    }
}

