/*
 * Decompiled with CFR 0.152.
 */
package com.develouz.sdk;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.util.TypedValue;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class RawStream
extends FilterInputStream {
    private Context a;
    private boolean b;
    private Cipher c;
    private byte[] d = new byte[512];
    private boolean e = false;
    private byte[] f;
    private int g = 0;
    private int h = 0;

    public RawStream(Context context, int resId) {
        super(context.getResources().openRawResource(resId));
        this.a = context;
        TypedValue typedValue = new TypedValue();
        this.a.getResources().getValue(resId, typedValue, true);
        this.b = typedValue.string.toString().endsWith(".enc");
    }

    public boolean initialize() throws SignatureException {
        try {
            if (!this.b) {
                return false;
            }
            PackageInfo packageInfo = this.a.getPackageManager().getPackageInfo(this.a.getPackageName(), 64);
            Signature[] signatureArray = packageInfo.signatures;
            byte[] byArray = signatureArray[0].toByteArray();
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
            PublicKey publicKey = x509Certificate.getPublicKey();
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, publicKey);
            byte[] byArray2 = new byte[super.read() * 32];
            super.read(byArray2, 0, byArray2.length);
            byte[] byArray3 = cipher.doFinal(byArray2);
            byte[] byArray4 = new byte[20];
            System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
            byte[] byArray5 = MessageDigest.getInstance("SHA-1").digest(this.a.getPackageName().getBytes("UTF-8"));
            if (!MessageDigest.isEqual(byArray4, byArray5)) {
                throw new SignatureException();
            }
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray3, 20, 16, "AES");
            this.c = Cipher.getInstance("AES/CBC/PKCS5Padding");
            this.c.init(2, (Key)secretKeySpec, new IvParameterSpec(byArray3, 36, 16));
            return true;
        }
        catch (Exception exception) {
            throw new SignatureException("Piracy detected! This is non-genuine and counterfeit application", exception);
        }
    }

    private int a() throws IOException {
        if (this.c == null) {
            throw new IOException("Cipher is not initialized");
        }
        if (this.e) {
            return -1;
        }
        int n = super.read(this.d, 0, this.d.length);
        if (n == -1) {
            this.e = true;
            try {
                this.f = this.c.doFinal();
            }
            catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
                this.f = null;
            }
            if (this.f == null) {
                return -1;
            }
            this.g = 0;
            this.h = this.f.length;
            return this.h;
        }
        try {
            this.f = this.c.update(this.d, 0, n);
        }
        catch (IllegalStateException illegalStateException) {
            this.f = null;
        }
        this.g = 0;
        this.h = this.f == null ? 0 : this.f.length;
        return this.h;
    }

    @Override
    public int read() throws IOException {
        if (!this.b) {
            return super.read();
        }
        if (this.g >= this.h) {
            int n = 0;
            while (n == 0) {
                n = this.a();
            }
            if (n == -1) {
                return -1;
            }
        }
        return this.f[this.g++] & 0xFF;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int n;
        if (!this.b) {
            return super.read(b2, off, len);
        }
        if (this.g >= this.h) {
            n = 0;
            while (n == 0) {
                n = this.a();
            }
            if (n == -1) {
                return -1;
            }
        }
        if (len <= 0) {
            return 0;
        }
        n = this.h - this.g;
        if (len < n) {
            n = len;
        }
        if (b2 != null) {
            System.arraycopy(this.f, this.g, b2, off, n);
        }
        this.g += n;
        return n;
    }

    @Override
    public long skip(long n) throws IOException {
        if (!this.b) {
            return super.skip(n);
        }
        int n2 = this.h - this.g;
        if (n > (long)n2) {
            n = n2;
        }
        if (n < 0L) {
            return 0L;
        }
        this.g = (int)((long)this.g + n);
        return n;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (!this.b) {
            return;
        }
        try {
            if (this.c != null) {
                this.c.doFinal();
            }
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            // empty catch block
        }
        this.g = 0;
        this.h = 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

