/*
 * Decompiled with CFR 0.152.
 */
package com.develouz.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Html;
import android.text.Spanned;
import android.util.Base64;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import androidx.core.content.ContextCompat;
import java.security.MessageDigest;
import java.util.concurrent.atomic.AtomicInteger;

public class Helper {
    private static final char[] a = "0123456789ABCDEF".toCharArray();

    public static String getApplicationName(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        int n = applicationInfo.labelRes;
        return n == 0 ? applicationInfo.nonLocalizedLabel.toString() : context.getString(n);
    }

    public static Drawable getApplicationIcon(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        try {
            Resources resources = context.getPackageManager().getResourcesForApplication(applicationInfo);
            Drawable drawable2 = resources.getDrawableForDensity(applicationInfo.icon, 640);
            if (drawable2 == null) {
                drawable2 = resources.getDrawableForDensity(applicationInfo.icon, 480);
            }
            if (drawable2 == null) {
                drawable2 = resources.getDrawableForDensity(applicationInfo.icon, 320);
            }
            if (drawable2 == null) {
                throw new PackageManager.NameNotFoundException();
            }
            return drawable2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return ContextCompat.getDrawable((Context)context, (int)applicationInfo.icon);
        }
    }

    public static String getVersionName(Context context) {
        try {
            return "v" + context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return null;
        }
    }

    public static void assignId(View view) {
        if (Build.VERSION.SDK_INT < 17) {
            int n;
            int n2;
            AtomicInteger atomicInteger = new AtomicInteger(1);
            do {
                if ((n = (n2 = atomicInteger.get()) + 1) <= 0xFFFFFF) continue;
                n = 1;
            } while (!atomicInteger.compareAndSet(n2, n));
            view.setId(n2);
        } else {
            view.setId(View.generateViewId());
        }
    }

    public static int dpToPx(Context context, int dp) {
        float f2 = context.getResources().getDisplayMetrics().density;
        return (int)((float)dp * f2 + 0.5f);
    }

    public static boolean empty(String text) {
        return text == null || text.trim().length() == 0;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] cArray = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int n = bytes[i] & 0xFF;
            cArray[i * 2] = a[n >>> 4];
            cArray[i * 2 + 1] = a[n & 0xF];
        }
        return new String(cArray);
    }

    public static void showKeyboard(Activity activity) {
        InputMethodManager inputMethodManager = (InputMethodManager)activity.getSystemService("input_method");
        if (inputMethodManager != null) {
            inputMethodManager.showSoftInput(activity.getCurrentFocus(), 1);
        }
    }

    public static void hideKeyboard(Activity activity) {
        InputMethodManager inputMethodManager = (InputMethodManager)activity.getSystemService("input_method");
        if (inputMethodManager != null && activity.getCurrentFocus() != null) {
            inputMethodManager.hideSoftInputFromWindow(activity.getCurrentFocus().getWindowToken(), 0);
        }
    }

    public static Spanned fromHtml(String source) {
        if (Build.VERSION.SDK_INT >= 24) {
            return Html.fromHtml((String)source, (int)0);
        }
        return Html.fromHtml((String)source);
    }

    public static String md5(String text) {
        try {
            if (text == null) {
                return "NULL";
            }
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = text.getBytes("UTF-8");
            messageDigest.update(byArray, 0, byArray.length);
            byte[] byArray2 = messageDigest.digest();
            return Base64.encodeToString((byte[])byArray2, (int)11);
        }
        catch (Exception exception) {
            return "NULL";
        }
    }
}

