/*
 * Decompiled with CFR 0.152.
 */
package com.develouz.sdk;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class FileUtils {
    public static String read(File fileSource) {
        try {
            if (!fileSource.exists()) {
                return null;
            }
            return FileUtils.read(new FileInputStream(fileSource));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String read(InputStream source) {
        try {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            byte[] byArray = new byte[1024];
            while ((n = source.read(byArray)) != -1) {
                stringBuilder.append(new String(byArray, 0, n));
            }
            source.close();
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void write(String textSource, File fileDestination) {
        try {
            if (textSource == null) {
                fileDestination.delete();
            }
            FileUtils.write(textSource, new FileOutputStream(fileDestination));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void write(String textSource, OutputStream destination) {
        try {
            if (textSource == null) {
                return;
            }
            PrintWriter printWriter = new PrintWriter(destination);
            printWriter.write(textSource);
            printWriter.close();
            destination.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean delete(File file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            boolean bl = true;
            for (File file2 : file.listFiles()) {
                bl &= FileUtils.delete(file2);
            }
            return bl;
        }
        return file.delete();
    }

    public static void copy(InputStream source, OutputStream destination) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = source.read(byArray)) != -1) {
            destination.write(byArray, 0, n);
        }
        destination.close();
        source.close();
    }
}

