/*
 * Decompiled with CFR 0.152.
 */
package com.develouz.menu;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.TypedArray;
import android.net.Uri;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.Toolbar;
import com.develouz.lib.R;
import com.develouz.sdk.Helper;
import com.develouz.sdk.Theme;
import com.develouz.view.ViewDesign;
import com.develouz.view.ViewDesignAd;
import java.util.LinkedHashMap;
import java.util.Map;

public class DevelouzMenu {
    private final Context a;
    private final Menu b;
    private final Theme c;
    private final Map<a, Integer> d;
    private Toolbar e;
    private View f;
    private MenuItem g;
    private MenuItem h;
    private MenuItem i;
    private ViewDesign j;

    public DevelouzMenu(Context context, Menu menu) {
        this.a = context;
        this.b = menu;
        this.c = new Theme(context, null, 0, R.styleable.DevelouzMenu, R.styleable.DevelouzMenu_develouzMenu);
        this.d = new LinkedHashMap<a, Integer>();
    }

    public void create() {
        this.b.clear();
        this.a();
        this.b();
    }

    private void a() {
        TypedArray typedArray = this.c.obtainTypedArray(R.styleable.DevelouzMenu_viewList, 0);
        for (int i = 0; i < typedArray.length(); ++i) {
            int n = typedArray.getResourceId(i, 0);
            if (n == 0) continue;
            TypedArray typedArray2 = this.a.obtainStyledAttributes(n, R.styleable.DevelouzMenu);
            MenuItem menuItem = this.b.add(1, n, 0, (CharSequence)typedArray2.getString(R.styleable.DevelouzMenu_title)).setIcon(typedArray2.getDrawable(R.styleable.DevelouzMenu_icon)).setVisible(typedArray2.getBoolean(R.styleable.DevelouzMenu_visible, true));
            typedArray2.recycle();
            if (!menuItem.isVisible() || this.g != null) continue;
            this.g = menuItem;
        }
        typedArray.recycle();
        this.b.setGroupCheckable(1, true, true);
    }

    private void b() {
        TypedArray typedArray = this.c.obtainTypedArray(R.styleable.DevelouzMenu_menuList, 0);
        for (int i = 0; i < typedArray.length(); ++i) {
            int n = typedArray.getResourceId(i, 0);
            if (n == 0) continue;
            TypedArray typedArray2 = this.a.obtainStyledAttributes(n, R.styleable.DevelouzMenu);
            boolean bl = typedArray2.getBoolean(R.styleable.DevelouzMenu_visible, true);
            this.b.add(2, n, 0, (CharSequence)typedArray2.getString(R.styleable.DevelouzMenu_title)).setIcon(typedArray2.getDrawable(R.styleable.DevelouzMenu_icon)).setVisible(bl);
            this.d.put(com.develouz.menu.DevelouzMenu$a.a(this.a(typedArray2.getString(R.styleable.DevelouzMenu_menuClass))), n);
            typedArray2.recycle();
        }
        typedArray.recycle();
        this.b.setGroupCheckable(2, false, false);
    }

    public MenuItem getFirst() {
        return this.g;
    }

    public MenuItem getSelected() {
        return this.h;
    }

    public void select(MenuItem item) {
        if (item == null) {
            return;
        }
        if (item.getGroupId() == 1) {
            this.a(item);
        } else if (item.getGroupId() == 2) {
            this.b(item);
        }
    }

    private void a(MenuItem menuItem) {
        menuItem.setChecked(true);
        this.h = menuItem;
    }

    private void b(MenuItem menuItem) {
        TypedArray typedArray = this.a.obtainStyledAttributes(menuItem.getItemId(), R.styleable.DevelouzMenu);
        String string2 = typedArray.getString(R.styleable.DevelouzMenu_menuClass);
        switch (com.develouz.menu.DevelouzMenu$a.a(this.a(string2))) {
            case a: {
                this.freeAds();
                break;
            }
            case b: {
                this.moreApps();
                break;
            }
            case c: {
                this.shareApp();
                break;
            }
            case d: {
                this.rateApp();
                break;
            }
            case e: {
                this.closeApp();
            }
        }
        typedArray.recycle();
    }

    public boolean shouldDraw() {
        return this.h != null && !this.h.equals(this.i);
    }

    public ViewDesign drawView() {
        if (this.h == null) {
            return null;
        }
        this.i = this.h;
        int n = this.h.getItemId();
        TypedArray typedArray = this.a.obtainStyledAttributes(n, R.styleable.DevelouzMenu);
        ViewDesign viewDesign = null;
        try {
            String string2 = typedArray.getString(R.styleable.DevelouzMenu_viewClass);
            Class<?> clazz = Class.forName(this.a(string2));
            viewDesign = (ViewDesign)((Object)clazz.getDeclaredConstructor(Context.class, Integer.TYPE).newInstance(this.a, n));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        typedArray.recycle();
        this.j = viewDesign;
        return viewDesign;
    }

    private String a(String string2) {
        if (string2 == null) {
            return null;
        }
        return string2.startsWith(".") ? "com.develouz" + string2 : string2;
    }

    public boolean onBackPressed() {
        return this.j != null && this.j.onBackPressed();
    }

    public void setToolbar(Toolbar toolbar) {
        this.e = toolbar;
        if (this.e != null) {
            this.e.setVisibility(this.c.getBoolean(R.styleable.DevelouzMenu_toolbar, true) ? 0 : 8);
        }
    }

    public void setHeader(View header, int iconId, int titleId, int subtitleId) {
        this.f = header;
        if (header != null) {
            TextView textView;
            TextView textView2;
            ImageView imageView = (ImageView)header.findViewById(iconId);
            if (imageView != null && this.c.hasValue(R.styleable.DevelouzMenu_icon)) {
                imageView.setImageResource(this.c.getResourceId(R.styleable.DevelouzMenu_icon, 0));
            }
            if ((textView2 = (TextView)header.findViewById(titleId)) != null && this.c.hasValue(R.styleable.DevelouzMenu_title)) {
                textView2.setText((CharSequence)this.c.getString(R.styleable.DevelouzMenu_title));
            }
            if ((textView = (TextView)header.findViewById(subtitleId)) != null && this.c.hasValue(R.styleable.DevelouzMenu_subtitle)) {
                textView.setText((CharSequence)this.c.getString(R.styleable.DevelouzMenu_subtitle));
            }
        }
    }

    private String a(TypedArray typedArray, int n, int n2) {
        if (typedArray == null) {
            return this.a.getString(n2);
        }
        String string2 = typedArray.getString(n);
        string2 = Helper.empty(string2) ? this.a.getString(n2) : string2;
        return string2.replace("[NAME]", Helper.getApplicationName(this.a)).replace("[ID]", this.a.getPackageName());
    }

    private int a(a a2) {
        return this.d.containsKey((Object)a2) ? this.d.get((Object)a2) : 0;
    }

    public void freeAds() {
        if (this.j instanceof ViewDesignAd) {
            ((ViewDesignAd)this.j).ads().showRewardedDialog();
        }
    }

    public void moreApps() {
        TypedArray typedArray = this.a.obtainStyledAttributes(this.a(com.develouz.menu.DevelouzMenu$a.b), R.styleable.DevelouzMenu);
        this.a.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/dev?id=" + typedArray.getString(R.styleable.DevelouzMenu_developerId)))));
        typedArray.recycle();
    }

    public void shareApp() {
        TypedArray typedArray = this.a.obtainStyledAttributes(this.a(com.develouz.menu.DevelouzMenu$a.c), R.styleable.DevelouzMenu);
        String string2 = this.a(typedArray, R.styleable.DevelouzMenu_message, R.string.develouz_menu_share_message);
        String string3 = this.a(typedArray, R.styleable.DevelouzMenu_dialog, R.string.develouz_menu_share_dialog);
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.TEXT", string2);
        this.a.startActivity(Intent.createChooser((Intent)intent, (CharSequence)string3));
        typedArray.recycle();
    }

    public void rateApp() {
        TypedArray typedArray = this.a.obtainStyledAttributes(this.a(com.develouz.menu.DevelouzMenu$a.d), R.styleable.DevelouzMenu);
        String string2 = this.a(typedArray, R.styleable.DevelouzMenu_message, R.string.develouz_menu_rate_message);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.a);
        builder.setMessage((CharSequence)string2);
        builder.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                DevelouzMenu.this.a.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + DevelouzMenu.this.a.getPackageName()))));
            }
        });
        builder.setNegativeButton(0x1040000, null);
        builder.show();
        typedArray.recycle();
    }

    public void closeApp() {
        TypedArray typedArray = this.a.obtainStyledAttributes(this.a(com.develouz.menu.DevelouzMenu$a.e), R.styleable.DevelouzMenu);
        String string2 = this.a(typedArray, R.styleable.DevelouzMenu_message, R.string.develouz_menu_close_message);
        if (!typedArray.getBoolean(R.styleable.DevelouzMenu_confirm, true)) {
            if (this.a instanceof Activity) {
                ((Activity)this.a).finish();
            }
            return;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(this.a);
        builder.setMessage((CharSequence)string2);
        builder.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                if (DevelouzMenu.this.a instanceof Activity) {
                    ((Activity)DevelouzMenu.this.a).finish();
                }
            }
        });
        builder.setNegativeButton(0x1040000, null);
        builder.show();
        typedArray.recycle();
    }

    public void destroy() {
        this.c.recycle();
    }

    private static enum a {
        a("com.develouz.menu.FreeAds"),
        b("com.develouz.menu.MoreApps"),
        c("com.develouz.menu.ShareApp"),
        d("com.develouz.menu.RateApp"),
        e("com.develouz.menu.CloseApp"),
        f("");

        private String g;

        private a(String string3) {
            this.g = string3;
        }

        public static a a(String string2) {
            for (a a2 : com.develouz.menu.DevelouzMenu$a.values()) {
                if (!a2.g.equals(string2)) continue;
                return a2;
            }
            return f;
        }
    }
}

