/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.smartlock;

import android.app.Activity;
import android.content.Intent;
import android.content.IntentSender;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.auth.api.credentials.Credential;
import com.google.android.gms.auth.api.credentials.CredentialRequest;
import com.google.android.gms.auth.api.credentials.CredentialRequestResponse;
import com.google.android.gms.auth.api.credentials.Credentials;
import com.google.android.gms.auth.api.credentials.CredentialsClient;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;

public class SmartLockManager {
    private static final String TAG = SmartLockManager.class.getSimpleName();
    private static final int RC_READ = 456;
    private static final int RC_SAVE = 458;
    private final Activity mActivity;
    private final CredentialsClient mCredentialsClient;
    private CredentialListener mCredentialListener;

    public SmartLockManager(Activity activity) {
        this.mActivity = activity;
        this.mCredentialsClient = Credentials.getClient((Activity)activity);
    }

    public void setCredentialListener(CredentialListener credentialListener) {
        this.mCredentialListener = credentialListener;
    }

    public void getCredentialsAsync() {
        CredentialRequest mCredentialRequest = new CredentialRequest.Builder().setPasswordLoginSupported(true).build();
        this.mCredentialsClient.request(mCredentialRequest).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<CredentialRequestResponse>(){

            public void onComplete(@NonNull Task<CredentialRequestResponse> task) {
                if (task.isSuccessful()) {
                    SmartLockManager.this.onCredentialRetrieved(((CredentialRequestResponse)task.getResult()).getCredential());
                    return;
                }
                Exception e = task.getException();
                if (e instanceof ResolvableApiException) {
                    try {
                        ResolvableApiException rae = (ResolvableApiException)e;
                        rae.startResolutionForResult(SmartLockManager.this.mActivity, 456);
                    }
                    catch (IntentSender.SendIntentException ex) {
                        Log.e((String)TAG, (String)"Failed to send resolution.", (Throwable)ex);
                    }
                } else if (e instanceof ApiException) {
                    Log.e((String)TAG, (String)"Unsuccessful credential request.", (Throwable)e);
                    ApiException ae = (ApiException)e;
                    int n = ae.getStatusCode();
                }
            }
        });
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 456) {
            if (resultCode == -1) {
                Credential credential = (Credential)data.getParcelableExtra("com.google.android.gms.credentials.Credential");
                this.onCredentialRetrieved(credential);
            } else {
                Log.e((String)TAG, (String)"Credential Read: NOT OK");
            }
        } else if (requestCode == 458 && resultCode != -1) {
            Log.e((String)TAG, (String)"Save Credentials Failed");
        }
    }

    private void onCredentialRetrieved(Credential credential) {
        if (this.mCredentialListener != null) {
            this.mCredentialListener.onCredential(credential);
        }
        Log.e((String)"credential", (String)(credential.getId() + "=>" + credential.getPassword()));
    }

    public void saveCredentials(String name, String email, String password) {
        Credential credential = new Credential.Builder(email).setPassword(password).setName(name).build();
        this.mCredentialsClient.save(credential).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

            public void onComplete(@NonNull Task<Void> task) {
                if (task.isSuccessful()) {
                    Log.d((String)TAG, (String)"SAVE: OK");
                    return;
                }
                Exception e = task.getException();
                if (e instanceof ResolvableApiException) {
                    ResolvableApiException rae = (ResolvableApiException)e;
                    try {
                        rae.startResolutionForResult(SmartLockManager.this.mActivity, 458);
                    }
                    catch (IntentSender.SendIntentException ex) {
                        Log.e((String)TAG, (String)"Failed to send resolution.", (Throwable)ex);
                    }
                }
            }
        });
    }

    public static interface CredentialListener {
        public void onCredential(Credential var1);
    }
}

