package com.devdigital.networklib.task;

import com.devdigital.networklib.listener.ErrorListener;
import com.devdigital.networklib.listener.ResponseListener;
import com.devdigital.networklib.model.NetworkStackResponse;

/**
 * @author Dhaval Patel
 * @version 1.0
 * @since 7 April 2017
 */
public abstract class Task<T> {

    protected ResponseListener<T> responseListener;
    protected ErrorListener errorListener;

    public Task() {
    }

    public abstract Task addOnSuccessListener(ResponseListener<T> listener);

    public abstract Task addOnErrorListener(ErrorListener listener);

    public void publishResult(T response){
        if(responseListener!=null) responseListener.onResponse(response);
    }

    public void publishError(NetworkStackResponse response){
        if(errorListener!=null) errorListener.onError(response);
    }

}
