/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.networklib.utils;

import android.os.Build;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtils {
    public static String encodeToSHA128String(String text) {
        return HashUtils.encodeToSHAString("SHA-128", text);
    }

    public static String encodeToSHA256String(String text) {
        return HashUtils.encodeToSHAString("SHA-256", text);
    }

    private static String encodeToSHAString(String algorithm, String text) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] hash = Build.VERSION.SDK_INT >= 19 ? digest.digest(text.getBytes(StandardCharsets.UTF_8)) : digest.digest(text.getBytes());
            return HashUtils.bytesToHex(hash);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder();
        for (byte aHash : hash) {
            String hex = Integer.toHexString(0xFF & aHash);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

