/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.networklib;

import android.content.Context;
import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.gsonparserfactory.GsonParserFactory;
import com.androidnetworking.interceptors.HttpLoggingInterceptor;
import com.androidnetworking.interfaces.Parser;
import com.devdigital.networklib.handler.BaseWebResponseHandler;
import com.devdigital.networklib.handler.RefreshTokenManager;
import com.devdigital.networklib.ssl.Tls12SocketFactory;
import com.devdigital.networklib.stack.AndroidNetworkingStack;
import com.devdigital.networklib.stack.INetworkStack;
import com.facebook.stetho.Stetho;
import com.facebook.stetho.okhttp3.StethoInterceptor;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class NetworkController {
    public static final Class<? extends INetworkStack> NETWORK_STACK_CLASS = AndroidNetworkingStack.class;
    private Class<? extends BaseWebResponseHandler> mWebResponseHandlerClass;
    private static NetworkController mNetworkController;
    private boolean mIsRefreshTokenSupported;
    private RefreshTokenManager mRefreshTokenManager;
    private boolean isDebuggable;
    private HttpLoggingInterceptor.Level mLogLevel;

    private NetworkController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NetworkController getInstance() {
        if (mNetworkController != null) return mNetworkController;
        Class<NetworkController> clazz = NetworkController.class;
        synchronized (NetworkController.class) {
            if (mNetworkController != null) return mNetworkController;
            mNetworkController = new NetworkController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mNetworkController;
        }
    }

    public NetworkController initAndroidNetworking(Context context, boolean isDebuggable) {
        this.isDebuggable = isDebuggable;
        if (isDebuggable) {
            Stetho.initializeWithDefaults((Context)context);
        }
        OkHttpClient.Builder mClientBuilder = new OkHttpClient.Builder().followRedirects(true).followSslRedirects(true).retryOnConnectionFailure(true).cache(null).connectTimeout(5L, TimeUnit.SECONDS).writeTimeout(5L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS);
        OkHttpClient.Builder builder = Tls12SocketFactory.enableTls12OnPreLollipop(mClientBuilder);
        if (isDebuggable) {
            builder.addNetworkInterceptor((Interceptor)new StethoInterceptor());
        }
        builder.readTimeout(1L, TimeUnit.MINUTES);
        builder.connectTimeout(10L, TimeUnit.SECONDS);
        OkHttpClient okHttpClient = builder.build();
        AndroidNetworking.initialize((Context)context, (OkHttpClient)okHttpClient);
        AndroidNetworking.setParserFactory((Parser.Factory)new GsonParserFactory());
        if (isDebuggable) {
            AndroidNetworking.enableLogging((HttpLoggingInterceptor.Level)HttpLoggingInterceptor.Level.BODY);
        }
        return this;
    }

    public void setWebResponseHandler(Class<? extends BaseWebResponseHandler> cls) {
        this.mWebResponseHandlerClass = cls;
    }

    public Class<? extends BaseWebResponseHandler> getWebResponseHandler() {
        return this.mWebResponseHandlerClass;
    }

    public NetworkController setRefreshTokenSupported() {
        this.mIsRefreshTokenSupported = true;
        return this;
    }

    public boolean isRefreshTokenSupported() {
        return this.mIsRefreshTokenSupported;
    }

    public void setRefreshTokenManager(RefreshTokenManager manager) {
        this.mRefreshTokenManager = manager;
    }

    public RefreshTokenManager getRefreshTokenManager() {
        return this.mRefreshTokenManager;
    }

    public void setLogLevel(HttpLoggingInterceptor.Level level) {
        if (this.mLogLevel == null || !this.mLogLevel.equals((Object)level)) {
            AndroidNetworking.enableLogging((HttpLoggingInterceptor.Level)level);
        }
    }
}

