package com.devdigital.networklib.utils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtils {

    public static String encodeToSHA128String(String text) {
        return encodeToSHAString("SHA-128", text);
    }

    public static String encodeToSHA256String(String text) {
        return encodeToSHAString("SHA-256", text);
    }

	private static String encodeToSHAString(String algorithm, String text) {
		try {
			MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] hash;
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.KITKAT) {
                hash = digest.digest(text.getBytes(StandardCharsets.UTF_8));
            }else{
                hash = digest.digest(text.getBytes());
            }
            return bytesToHex(hash);
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
			return null;
		}
	}

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder();
        for (byte aHash : hash) {
            String hex = Integer.toHexString(0xff & aHash);
            if (hex.length() == 1) hexString.append('0');
            hexString.append(hex);
        }
        return hexString.toString();
    }
	
}