package com.devdigital.networklib.handler;

import com.androidnetworking.interfaces.JSONArrayRequestListener;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.StringRequestListener;
import com.devdigital.networklib.entity.BaseEntity;
import com.devdigital.networklib.task.Task;
import com.devdigital.networklib.model.NetworkStackResponse;

import org.json.JSONArray;
import org.json.JSONObject;

/**
 * Interface class for Web request executor.
 *
 * WebRequest Executor will be the Intermediate between UI and INetworkStack for WebService call.
 *
 * @author Dhaval Patel
 * @version 1.0
 * @since 21 November 2017
 */
public interface IWebRequestExecutor {

    Task<JSONObject> getAsJsonObjectAsync();

    Task<JSONArray> getAsJsonArrayAsync();

    Task<BaseEntity> getAsObjectAsync();

    <T>Task<T> getAsObjectAsync(Class<T> cls);

    Task<String> getAsStringAsync();

    NetworkStackResponse<JSONObject> getAsJsonObject();

    NetworkStackResponse<JSONArray> getAsJsonArray();

    NetworkStackResponse<BaseEntity> getAsObject();

    <T> NetworkStackResponse<T> getAsObject(Class<T> cls);

    NetworkStackResponse<String> getAsString();

}
