package com.devdigital.networklib.handler;

import android.content.Context;

import com.devdigital.networklib.listener.RefreshTokenResponseListener;
import com.devdigital.networklib.listener.ResponseListener;
import com.devdigital.networklib.model.NetworkStackResponse;

/**
 * Class to handle refresh token mechanism
 *
 * @author Dhaval Patel
 * @version 1.0
 * @since 15 June 2018
 */
public abstract class RefreshTokenManager {

    private static final int EXPIRY_TOKEN_STATUS_CODE = 498;

    protected RefreshTokenResponseListener refreshTokenResponseListener;

    public RefreshTokenManager(){

    }

    public int getExpiryTokenStatusCode(){
        return EXPIRY_TOKEN_STATUS_CODE;
    }

    public boolean isTokenRefreshRequired(NetworkStackResponse response){
        return false;
    }

    public RefreshTokenManager setRefreshTokenResponseListener(RefreshTokenResponseListener refreshTokenResponseListener) {
        this.refreshTokenResponseListener = refreshTokenResponseListener;
        return this;
    }

    public abstract void refreshAsync(Context context);

}
