/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.networklib.handler;

import android.os.Handler;
import android.util.Log;
import com.devdigital.networklib.NetworkController;
import com.devdigital.networklib.constants.NetworkError;
import com.devdigital.networklib.constants.ResponseStatus;
import com.devdigital.networklib.entity.BaseEntity;
import com.devdigital.networklib.exception.ResponseParsingException;
import com.devdigital.networklib.handler.BaseWebResponseHandler;
import com.devdigital.networklib.handler.IWebRequestExecutor;
import com.devdigital.networklib.handler.WebRequestBuilder;
import com.devdigital.networklib.json.JSONFactory;
import com.devdigital.networklib.listener.IWebResponseListener;
import com.devdigital.networklib.listener.RefreshTokenResponseListener;
import com.devdigital.networklib.model.NetworkStackResponse;
import com.devdigital.networklib.stack.INetworkStack;
import com.devdigital.networklib.task.JSONArrayTask;
import com.devdigital.networklib.task.JSONObjectTask;
import com.devdigital.networklib.task.ObjectTask;
import com.devdigital.networklib.task.StringTask;
import com.devdigital.networklib.task.Task;
import com.devdigital.networklib.utils.NetworkUtils;
import com.google.gson.JsonParseException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WebRequestExecutor
implements IWebRequestExecutor,
IWebResponseListener {
    private static final String TAG = WebRequestExecutor.class.getSimpleName();
    private WebRequestBuilder mWebRequestBuilder;
    private INetworkStack mNetworkStack;
    private BaseWebResponseHandler mWebResponseHandler;
    private NetworkController mNetworkController;
    private Class mResponseClass;
    private Task mTask;

    public WebRequestExecutor(WebRequestBuilder builder) {
        this.mWebRequestBuilder = builder;
        this.mNetworkController = NetworkController.getInstance();
        this.newNetworkStackInstance();
        try {
            this.mWebResponseHandler = this.mNetworkController.getWebResponseHandler().newInstance();
            this.mWebResponseHandler.setWebRequestBuilder(builder);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void newNetworkStackInstance() {
        try {
            Constructor<? extends INetworkStack> ctor = this.mWebRequestBuilder.getNetworkStack().getConstructor(WebRequestBuilder.class);
            this.mNetworkStack = ctor.newInstance(this.mWebRequestBuilder);
            this.mNetworkStack.setResponseListener(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Task<JSONObject> getAsJsonObjectAsync() {
        this.mTask = new JSONObjectTask();
        this.getStringAsync();
        return this.mTask;
    }

    @Override
    public Task<JSONArray> getAsJsonArrayAsync() {
        this.mTask = new JSONArrayTask();
        this.getStringAsync();
        return this.mTask;
    }

    @Override
    public Task<BaseEntity> getAsObjectAsync() {
        return this.getAsObjectAsync(BaseEntity.class);
    }

    @Override
    public <T> Task<T> getAsObjectAsync(Class<T> cls) {
        this.mTask = new ObjectTask();
        this.mResponseClass = cls;
        this.getStringAsync();
        return this.mTask;
    }

    @Override
    public NetworkStackResponse<JSONObject> getAsJsonObject() throws ResponseParsingException {
        return this.getResponse(this.getAsString(), JSONObject.class);
    }

    @Override
    public NetworkStackResponse<JSONArray> getAsJsonArray() throws ResponseParsingException {
        return this.getResponse(this.getAsString(), JSONArray.class);
    }

    @Override
    public NetworkStackResponse<BaseEntity> getAsObject() throws ResponseParsingException {
        return this.getAsObject(BaseEntity.class);
    }

    @Override
    public <T> NetworkStackResponse<T> getAsObject(Class<T> cls) throws ResponseParsingException {
        return this.getResponse(this.getAsString(), cls);
    }

    @Override
    public Task<String> getAsStringAsync() {
        this.mTask = new StringTask();
        this.getStringAsync();
        return this.mTask;
    }

    private void getStringAsync() {
        if (this.mWebRequestBuilder.isDebug()) {
            Log.d((String)TAG, (String)this.mWebRequestBuilder.toString());
        }
        if (!NetworkUtils.isNetworkAvailable(this.mWebRequestBuilder.getContext()).booleanValue()) {
            new Handler().postDelayed(() -> {
                NetworkStackResponse response = this.getNetworkErrorResponse();
                this.onResponse(ResponseStatus.SERVER_ERROR, response);
            }, 250L);
        } else {
            this.mWebResponseHandler.showProgressDialog();
            this.mNetworkStack.getAsync();
        }
    }

    @Override
    public NetworkStackResponse<String> getAsString() throws ResponseParsingException {
        if (this.mWebRequestBuilder.isDebug()) {
            Log.d((String)TAG, (String)this.mWebRequestBuilder.toString());
        }
        if (!NetworkUtils.isNetworkAvailable(this.mWebRequestBuilder.getContext()).booleanValue()) {
            NetworkStackResponse<String> response = new NetworkStackResponse<String>();
            response.setSuccess(false);
            response.setError(NetworkError.NO_NETWORK_ERROR);
            return response;
        }
        NetworkStackResponse<String> response = this.mNetworkStack.getSync();
        if (this.mWebRequestBuilder.isDebug()) {
            Log.d((String)TAG, (String)("Response:" + response.toString()));
        }
        return this.getResponse(response, String.class);
    }

    @Override
    public void onResponse(ResponseStatus responseStatus, Object result) {
        if (this.mWebRequestBuilder.isDebug()) {
            if (result != null) {
                Log.d((String)TAG, (String)("Status:" + responseStatus.name() + "\nResponse:" + result.toString()));
            } else {
                Log.d((String)TAG, (String)("Status:" + responseStatus.name() + "\nResponse:null"));
            }
        }
        this.mWebResponseHandler.hideProgressDialog();
        NetworkStackResponse response = (NetworkStackResponse)result;
        if (this.mNetworkController.isRefreshTokenSupported() && this.mNetworkController.getRefreshTokenManager().isTokenRefreshRequired(response)) {
            this.handleTokenExpiry(response);
            return;
        }
        this.publishTaskResponse(response);
    }

    private void publishTaskResponse(NetworkStackResponse<String> response) {
        if (this.mTask == null || this.mTask instanceof StringTask) {
            this.publishResponse(response, String.class);
        } else if (this.mTask instanceof ObjectTask) {
            this.publishResponse(response, this.mResponseClass);
        } else if (this.mTask instanceof JSONObjectTask) {
            this.publishResponse(response, JSONObject.class);
        } else if (this.mTask instanceof JSONArrayTask) {
            this.publishResponse(response, JSONArray.class);
        }
    }

    private void handleTokenExpiry(final NetworkStackResponse<String> response) {
        this.mNetworkController.getRefreshTokenManager().setRefreshTokenResponseListener(new RefreshTokenResponseListener(){

            @Override
            public void onResponse(boolean status, Map<String, Object> headers) {
                if (status) {
                    Map<String, Object> header = WebRequestExecutor.this.mWebRequestBuilder.getHeader();
                    if (header == null) {
                        header = new HashMap<String, Object>();
                    }
                    header.putAll(headers);
                    WebRequestExecutor.this.mWebRequestBuilder.setHeader(headers);
                    WebRequestExecutor.this.newNetworkStackInstance();
                    WebRequestExecutor.this.getStringAsync();
                } else {
                    WebRequestExecutor.this.publishTaskResponse(response);
                }
            }
        }).refreshAsync(this.mWebRequestBuilder.getContext());
    }

    private void publishResponse(NetworkStackResponse<String> response, Class cls) {
        try {
            NetworkStackResponse finalResponse = this.getResponse(response, cls);
            if (finalResponse.isSuccess()) {
                this.mTask.publishResult(finalResponse.getResult());
            } else {
                this.mTask.publishError(finalResponse);
            }
        }
        catch (ResponseParsingException ex) {
            ex.printStackTrace();
            this.mTask.publishError(ex.getNetworkStackResponse());
        }
    }

    private NetworkStackResponse getNetworkErrorResponse() {
        NetworkStackResponse response = new NetworkStackResponse();
        response.setError(NetworkError.NO_NETWORK_ERROR);
        response.setSuccess(false);
        return response;
    }

    private <T> NetworkStackResponse<T> getResponse(NetworkStackResponse<String> response, Class<T> t) throws ResponseParsingException {
        boolean status;
        if (response.isSuccess()) {
            boolean status2 = this.mWebResponseHandler.isSuccess(response);
            response.setSuccess(status2);
            if (!status2) {
                response.setError(NetworkError.HTTP_ERROR);
            }
        }
        NetworkStackResponse<Object> stackResponse = new NetworkStackResponse<Object>();
        stackResponse.setError(response.getError());
        stackResponse.setSuccess(response.isSuccess());
        stackResponse.setStatus(response.getStatus());
        stackResponse.setHeaders(response.getHeaders());
        try {
            if (response.isSuccess()) {
                if (t == JSONObject.class) {
                    stackResponse.setResult(new JSONObject(response.getResult()));
                } else if (t == JSONArray.class) {
                    stackResponse.setResult(new JSONArray(response.getResult()));
                } else if (t != String.class) {
                    stackResponse.setResult(JSONFactory.getInstance().fromJson(response.getResult(), t));
                }
            }
        }
        catch (JsonParseException | JSONException ex) {
            ex.printStackTrace();
            stackResponse.setSuccess(false);
            stackResponse.setError(NetworkError.INVALID_JSON_ERROR);
        }
        if (this.mWebRequestBuilder.isHandleError() && stackResponse.isSuccess() && !(status = t == String.class ? this.mWebResponseHandler.handleStringResponse((String)stackResponse.getResult()) : (t == JSONObject.class ? this.mWebResponseHandler.handleJSONObjectResponse((JSONObject)stackResponse.getResult()) : (t == JSONArray.class ? this.mWebResponseHandler.handleJSONArrayResponse((JSONArray)stackResponse.getResult()) : this.mWebResponseHandler.handleObjectResponse(stackResponse.getResult()))))) {
            stackResponse.setSuccess(false);
            stackResponse.setError(NetworkError.RESPONSE_HANDLING_ERROR);
        }
        if (!stackResponse.isSuccess()) {
            response.setSuccess(stackResponse.isSuccess());
            response.setError(stackResponse.getError());
            if (this.mWebRequestBuilder.isHandleError()) {
                this.mWebResponseHandler.handleError(response);
            }
            throw new ResponseParsingException(response);
        }
        return stackResponse;
    }
}

