package com.devdigital.networklib.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.Log;


/**
 * Utility for Networking
 *
 * @author Viral Gauswami
 * @version 1.0
 * @since 21 November 2017
 */
public class NetworkUtils {
    private static final String TAG = NetworkUtils.class.getSimpleName();

    private static final String PING_C_1_WWW_GOOGLE_COM = "ping -c 1 www.google.com";


    public synchronized static Boolean isNetworkAvailable(Context context) {
        /*
        if (android.os.Build.VERSION.SDK_INT >= Build.VERSION_CODES.O){
            return isNetworkAccessible();
        } else{
            return isNetworkConnected(context);
        }
        */
        return isNetworkConnected(context);
    }

    /**
     * Check internet connectivity by ping
     * @return boolean true if network available, else return false.
     */
    public synchronized static Boolean isNetworkAccessible() {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(PING_C_1_WWW_GOOGLE_COM);
            int returnVal = process.waitFor();
            boolean reachable = (returnVal == 0);
            if (reachable) {
                Log.e(TAG, "Internet access");
                return reachable;
            } else {
                Log.e(TAG, "No Internet access");
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            process.destroy();
        }
        return false;
    }

    private static boolean isNetworkConnected(Context context){
        ConnectivityManager conMgr = (ConnectivityManager) context.getApplicationContext().getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo activeNetwork = conMgr.getActiveNetworkInfo();
        boolean flag = activeNetwork != null && activeNetwork.isConnected();
        Log.i("Network", "Status:"+flag);
        return flag;
    }
}
