package com.devdigital.networklib.exception;

import com.devdigital.networklib.constants.NetworkError;
import com.devdigital.networklib.model.NetworkStackResponse;

/**
 * Exception to handle Web Service Response.
 *
 * @author Dhaval Patel
 * @version 1.0
 * @since 13 July 2018
 */
public class ResponseParsingException extends Exception{

    private NetworkStackResponse<String> response;

    public ResponseParsingException(NetworkStackResponse<String> response) {
        this.response = response;
    }

    public NetworkStackResponse<String> getNetworkStackResponse() {
        return response;
    }

    @Override
    public String toString() {
        return "WebRequestException{" +
                "response=" + response +
                "} " + super.toString();
    }

}
