/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.networklib.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;

public class NetworkUtils {
    private static final String TAG = NetworkUtils.class.getSimpleName();
    private static final String PING_C_1_WWW_GOOGLE_COM = "ping -c 1 www.google.com";

    public static synchronized Boolean isNetworkAvailable(Context context) {
        return NetworkUtils.isNetworkConnected(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Boolean isNetworkAccessible() {
        Process process = null;
        try {
            boolean reachable;
            process = Runtime.getRuntime().exec(PING_C_1_WWW_GOOGLE_COM);
            int returnVal = process.waitFor();
            boolean bl = reachable = returnVal == 0;
            if (reachable) {
                Log.e((String)TAG, (String)"Internet access");
                Boolean bl2 = reachable;
                return bl2;
            }
            Log.e((String)TAG, (String)"No Internet access");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            process.destroy();
        }
        return false;
    }

    private static boolean isNetworkConnected(Context context) {
        ConnectivityManager conMgr = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        NetworkInfo activeNetwork = conMgr.getActiveNetworkInfo();
        boolean flag = activeNetwork != null && activeNetwork.isConnected();
        Log.i((String)"Network", (String)("Status:" + flag));
        return flag;
    }
}

