/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.networklib.stack;

import android.os.AsyncTask;
import android.util.Log;
import com.devdigital.networklib.constants.NetworkError;
import com.devdigital.networklib.constants.ResponseStatus;
import com.devdigital.networklib.handler.WebRequestBuilder;
import com.devdigital.networklib.listener.IWebResponseListener;
import com.devdigital.networklib.model.NetworkStackResponse;
import com.devdigital.networklib.stack.INetworkStack;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;

public class HUrlConnectionStack
extends AsyncTask<Void, Void, String>
implements INetworkStack {
    private static final String TAG = HUrlConnectionStack.class.getSimpleName();
    private WebRequestBuilder mWebRequestBuilder;
    private IWebResponseListener mResponseListener;
    private int mStatusCode;
    private String mResponse;
    private Map<String, List<String>> mHeaders;
    private Exception mError;
    private static final String LINE_FEED = "\r\n";
    private final String BOUNDARY = "*****";

    public HUrlConnectionStack(WebRequestBuilder fields) {
        this.mWebRequestBuilder = fields;
    }

    @Override
    public void setResponseListener(IWebResponseListener listener) {
        this.mResponseListener = listener;
    }

    @Override
    public void getAsync() {
        this.execute(new Void[0]);
    }

    @Override
    public NetworkStackResponse<String> getSync() {
        this.doInBackground(new Void[0]);
        NetworkStackResponse<String> response = new NetworkStackResponse<String>();
        response.setHeaders(this.mHeaders);
        response.setResult(this.mResponse);
        response.setStatus(this.mStatusCode);
        if (this.mError != null) {
            if (this.mError instanceof ConnectException || this.mError instanceof SocketException) {
                response.setError(NetworkError.CONNECTION_ERROR);
            } else {
                response.setError(NetworkError.UNKNOWN_ERROR);
            }
        } else {
            response.setSuccess(this.mStatusCode == 200);
        }
        return response;
    }

    protected String doInBackground(Void ... voids) {
        try {
            WebRequestBuilder.RequestMethod requestMethod = this.mWebRequestBuilder.getRequestMethod();
            String url = this.getURL();
            this.showLog("HTTP URL is " + url);
            URL obj = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)obj.openConnection();
            this.setRequestHeaders(connection);
            switch (requestMethod) {
                case POST: 
                case PUT: 
                case DELETE: {
                    connection.setRequestMethod(requestMethod.name());
                    connection.setDoOutput(true);
                    this.writePostBody(connection);
                    break;
                }
                case GET: {
                    connection.setRequestMethod(requestMethod.name());
                    break;
                }
                case MULTI_PART: {
                    connection.setRequestMethod("POST");
                    connection.setDoInput(true);
                    connection.setDoOutput(true);
                    connection.setRequestProperty("Connection", "Keep-Alive");
                    connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=*****");
                    this.writeMultipartBody(connection);
                    break;
                }
                default: {
                    throw new RuntimeException("Request Method not supported");
                }
            }
            this.mStatusCode = connection.getResponseCode();
            this.mResponse = this.mStatusCode == 200 ? this.getResponseBody(connection.getInputStream()) : this.getResponseBody(connection.getErrorStream());
            this.mHeaders = connection.getHeaderFields();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mError = e;
        }
        return this.mResponse;
    }

    protected void onPostExecute(String s) {
        super.onPostExecute((Object)s);
        if (this.mResponseListener != null) {
            NetworkStackResponse<String> response = new NetworkStackResponse<String>();
            response.setStatus(this.mStatusCode);
            response.setHeaders(this.mHeaders);
            response.setResult(this.mResponse);
            if (this.mError != null) {
                if (this.mError instanceof ConnectException || this.mError instanceof SocketException) {
                    response.setError(NetworkError.CONNECTION_ERROR);
                } else {
                    response.setError(NetworkError.UNKNOWN_ERROR);
                }
            } else {
                response.setSuccess(this.mStatusCode == 200);
                if (this.mStatusCode != 200) {
                    response.setError(NetworkError.HTTP_ERROR);
                }
            }
            this.mResponseListener.onResponse(this.mStatusCode == 200 ? ResponseStatus.SUCCESS : ResponseStatus.HTTP_ERROR, response);
        }
    }

    private String getURL() {
        if (this.mWebRequestBuilder.getRequestMethod() == WebRequestBuilder.RequestMethod.GET) {
            if (this.mWebRequestBuilder.getRequestParams() == null) {
                return this.mWebRequestBuilder.getUrl();
            }
            return this.mWebRequestBuilder.getUrl() + "?" + this.getBodyParams();
        }
        return this.mWebRequestBuilder.getUrl();
    }

    private void setRequestHeaders(HttpURLConnection connection) {
        if (this.mWebRequestBuilder.getHeader() != null) {
            for (Map.Entry<String, Object> entries : this.mWebRequestBuilder.getHeader().entrySet()) {
                if (entries.getKey() == null || entries.getValue() == null) continue;
                connection.setRequestProperty(entries.getKey(), entries.getValue().toString());
            }
        }
    }

    private void writePostBody(HttpURLConnection connection) throws IOException {
        OutputStreamWriter os = new OutputStreamWriter(connection.getOutputStream());
        if (this.mWebRequestBuilder.getRequestJSON() != null) {
            String json = this.mWebRequestBuilder.getRequestJSON().toString();
            this.showLog("HTTP Post Body is " + json);
            os.write(json);
        } else if (this.mWebRequestBuilder.getRequestParams() != null && !this.mWebRequestBuilder.getRequestParams().isEmpty()) {
            String body = this.getBodyParams();
            this.showLog("HTTP Post Body is " + body);
            os.write(body);
        } else if (this.mWebRequestBuilder.getRequestBody() != null) {
            this.showLog("HTTP Post Body is " + this.mWebRequestBuilder.getRequestBody());
            os.write(this.mWebRequestBuilder.getRequestBody());
        }
        os.flush();
        os.close();
    }

    private void writeMultipartBody(HttpURLConnection connection) throws IOException {
        DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
        if (this.mWebRequestBuilder.getRequestParams() != null) {
            this.addMultipartFormField(outputStream);
        }
        if (this.mWebRequestBuilder.getMultipartFile() != null) {
            this.addMultipartFormFile(outputStream);
        }
        outputStream.writeBytes(LINE_FEED);
        outputStream.flush();
        outputStream.writeBytes("--*****--");
        outputStream.writeBytes(LINE_FEED);
        outputStream.flush();
        outputStream.close();
    }

    private String getResponseBody(InputStream inputStream) throws IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder response = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }

    public static String encodeToUTF8(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return text;
        }
    }

    private String getBodyParams() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.mWebRequestBuilder.getRequestParams().entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(String.format("%s=%s", entry.getKey(), entry.getValue().toString()));
        }
        return sb.toString();
    }

    public void addMultipartFormField(DataOutputStream outputStream) throws IOException {
        for (Map.Entry<String, Object> entry : this.mWebRequestBuilder.getRequestParams().entrySet()) {
            outputStream.writeBytes("--*****");
            outputStream.writeBytes(LINE_FEED);
            outputStream.writeBytes("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"");
            outputStream.writeBytes(LINE_FEED);
            outputStream.writeBytes("Content-Type: text/plain; charset=UTF-8");
            outputStream.writeBytes(LINE_FEED);
            outputStream.writeBytes(LINE_FEED);
            outputStream.writeBytes(entry.getValue().toString());
            outputStream.writeBytes(LINE_FEED);
            outputStream.flush();
        }
    }

    public void addMultipartFormFile(DataOutputStream outputStream) throws IOException {
        for (Map.Entry<String, File> entry : this.mWebRequestBuilder.getMultipartFile().entrySet()) {
            File file = entry.getValue();
            String fileName = file.getName();
            outputStream.writeBytes("--*****");
            outputStream.writeBytes(LINE_FEED);
            outputStream.writeBytes("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"; filename=\"" + fileName + "\"");
            outputStream.writeBytes(LINE_FEED);
            outputStream.writeBytes("Content-Type: " + URLConnection.guessContentTypeFromName(fileName));
            outputStream.writeBytes(LINE_FEED);
            outputStream.writeBytes("Content-Transfer-Encoding: binary");
            outputStream.writeBytes(LINE_FEED);
            outputStream.writeBytes(LINE_FEED);
            outputStream.flush();
            FileInputStream inputStream = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            int bytesRead = -1;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.writeBytes(LINE_FEED);
            outputStream.flush();
            inputStream.close();
        }
    }

    private void showLog(String message) {
        if (this.mWebRequestBuilder.isDebug()) {
            Log.i((String)TAG, (String)message);
        }
    }
}

