/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.networklib.handler;

import android.os.Handler;
import com.devdigital.networklib.NetworkController;
import com.devdigital.networklib.constants.NetworkError;
import com.devdigital.networklib.constants.ResponseStatus;
import com.devdigital.networklib.entity.BaseEntity;
import com.devdigital.networklib.handler.BaseWebResponseHandler;
import com.devdigital.networklib.handler.IWebRequestExecutor;
import com.devdigital.networklib.handler.WebRequestBuilder;
import com.devdigital.networklib.json.JSONFactory;
import com.devdigital.networklib.listener.IWebResponseListener;
import com.devdigital.networklib.model.NetworkStackResponse;
import com.devdigital.networklib.stack.INetworkStack;
import com.devdigital.networklib.task.JSONArrayTask;
import com.devdigital.networklib.task.JSONObjectTask;
import com.devdigital.networklib.task.ObjectTask;
import com.devdigital.networklib.task.StringTask;
import com.devdigital.networklib.task.Task;
import com.devdigital.networklib.utils.NetworkUtils;
import com.google.gson.JsonParseException;
import java.lang.reflect.Constructor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WebRequestExecutor
implements IWebRequestExecutor,
IWebResponseListener {
    private WebRequestBuilder mWebRequestBuilder;
    private INetworkStack mNetworkStack;
    private BaseWebResponseHandler mWebResponseHandler;
    private Class mResponseClass;
    private Task mTask;

    public WebRequestExecutor(WebRequestBuilder builder) {
        this.mWebRequestBuilder = builder;
        try {
            Constructor<? extends INetworkStack> ctor = builder.getNetworkStack().getConstructor(WebRequestBuilder.class);
            this.mNetworkStack = ctor.newInstance(builder);
            this.mNetworkStack.setResponseListener(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.mWebResponseHandler = NetworkController.getWebResponseHandler().newInstance();
            this.mWebResponseHandler.setWebRequestBuilder(builder);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Task<JSONObject> getAsJsonObjectAsync() {
        this.mTask = new JSONObjectTask();
        this.getStringAsync();
        return this.mTask;
    }

    @Override
    public Task<JSONArray> getAsJsonArrayAsync() {
        this.mTask = new JSONArrayTask();
        this.getStringAsync();
        return this.mTask;
    }

    @Override
    public Task<BaseEntity> getAsObjectAsync() {
        return this.getAsObjectAsync(BaseEntity.class);
    }

    @Override
    public <T> Task<T> getAsObjectAsync(Class<T> cls) {
        this.mTask = new ObjectTask();
        this.mResponseClass = cls;
        this.getStringAsync();
        return this.mTask;
    }

    @Override
    public NetworkStackResponse<JSONObject> getAsJsonObject() {
        return this.getResponse(this.getAsString(), JSONObject.class);
    }

    @Override
    public NetworkStackResponse<JSONArray> getAsJsonArray() {
        return this.getResponse(this.getAsString(), JSONArray.class);
    }

    @Override
    public NetworkStackResponse<BaseEntity> getAsObject() {
        return this.getAsObject(BaseEntity.class);
    }

    @Override
    public <T> NetworkStackResponse<T> getAsObject(Class<T> cls) {
        return this.getResponse(this.getAsString(), cls);
    }

    @Override
    public Task<String> getAsStringAsync() {
        this.mTask = new StringTask();
        this.getStringAsync();
        return this.mTask;
    }

    private void getStringAsync() {
        if (!NetworkUtils.isNetworkAvailable(this.mWebRequestBuilder.getContext()).booleanValue()) {
            new Handler().postDelayed(() -> {
                NetworkStackResponse response = this.getNetworkErrorResponse();
                this.onResponse(ResponseStatus.SERVER_ERROR, response);
            }, 250L);
        } else {
            this.mWebResponseHandler.showProgressDialog();
            this.mNetworkStack.getAsync();
        }
    }

    @Override
    public NetworkStackResponse<String> getAsString() {
        if (!NetworkUtils.isNetworkAvailable(this.mWebRequestBuilder.getContext()).booleanValue()) {
            NetworkStackResponse<String> response = new NetworkStackResponse<String>();
            response.setSuccess(false);
            response.setError(NetworkError.NO_NETWORK_ERROR);
            return response;
        }
        NetworkStackResponse<String> response = this.mNetworkStack.getSync();
        return this.getResponse(response, String.class);
    }

    @Override
    public void onResponse(ResponseStatus responseStatus, Object result) {
        this.mWebResponseHandler.hideProgressDialog();
        NetworkStackResponse response = (NetworkStackResponse)result;
        if (this.mTask == null || this.mTask instanceof StringTask) {
            this.publishResponse(response, String.class);
        } else if (this.mTask instanceof ObjectTask) {
            this.publishResponse(response, this.mResponseClass);
        } else if (this.mTask instanceof JSONObjectTask) {
            this.publishResponse(response, JSONObject.class);
        } else if (this.mTask instanceof JSONArrayTask) {
            this.publishResponse(response, JSONArray.class);
        }
    }

    private void publishResponse(NetworkStackResponse<String> response, Class cls) {
        NetworkStackResponse<String> finalResponse = response;
        if (cls != String.class) {
            finalResponse = this.getResponse(response, cls);
        }
        if (finalResponse.isSuccess()) {
            this.mTask.publishResult(finalResponse.getResult());
        } else {
            this.mTask.publishError(response);
        }
    }

    private NetworkStackResponse getNetworkErrorResponse() {
        NetworkStackResponse response = new NetworkStackResponse();
        response.setError(NetworkError.NO_NETWORK_ERROR);
        response.setSuccess(false);
        return response;
    }

    private <T> NetworkStackResponse<T> getResponse(NetworkStackResponse<String> response, Class<T> t) {
        NetworkStackResponse<Object> stackResponse = new NetworkStackResponse<Object>();
        stackResponse.setError(response.getError());
        stackResponse.setSuccess(response.isSuccess());
        stackResponse.setStatus(response.getStatus());
        stackResponse.setHeaders(response.getHeaders());
        try {
            if (response.isSuccess()) {
                if (t == JSONObject.class) {
                    stackResponse.setResult(new JSONObject(response.getResult()));
                } else if (t == JSONArray.class) {
                    stackResponse.setResult(new JSONArray(response.getResult()));
                } else if (t != String.class) {
                    stackResponse.setResult(JSONFactory.getInstance().fromJson(response.getResult(), t));
                }
            }
        }
        catch (JsonParseException | JSONException ex) {
            ex.printStackTrace();
            stackResponse.setSuccess(true);
            stackResponse.setError(NetworkError.INVALID_JSON_ERROR);
        }
        if (this.mWebRequestBuilder.isHandleError()) {
            if (stackResponse.isSuccess()) {
                boolean status = t == String.class ? this.mWebResponseHandler.handleStringResponse((String)stackResponse.getResult()) : (t == JSONObject.class ? this.mWebResponseHandler.handleJSONObjectResponse((JSONObject)stackResponse.getResult()) : (t == JSONArray.class ? this.mWebResponseHandler.handleJSONArrayResponse((JSONArray)stackResponse.getResult()) : this.mWebResponseHandler.handleObjectResponse(stackResponse.getResult())));
                if (!status) {
                    stackResponse.setSuccess(false);
                    stackResponse.setError(NetworkError.RESPONSE_HANDLING_ERROR);
                    return stackResponse;
                }
            } else {
                this.mWebResponseHandler.handleError(response);
            }
        }
        return stackResponse;
    }
}

