/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.networklib;

import android.content.Context;
import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.gsonparserfactory.GsonParserFactory;
import com.androidnetworking.interfaces.Parser;
import com.devdigital.networklib.handler.BaseWebResponseHandler;
import com.devdigital.networklib.ssl.Tls12SocketFactory;
import com.devdigital.networklib.stack.AndroidNetworkingStack;
import com.devdigital.networklib.stack.INetworkStack;
import com.facebook.stetho.Stetho;
import com.facebook.stetho.okhttp3.StethoInterceptor;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class NetworkController {
    public static final Class<? extends INetworkStack> NETWORK_STACK_CLASS = AndroidNetworkingStack.class;
    private static Class<? extends BaseWebResponseHandler> mWebResponseHandlerClass;

    public static void setWebResponseHandler(Class<? extends BaseWebResponseHandler> cls) {
        mWebResponseHandlerClass = cls;
    }

    public static Class<? extends BaseWebResponseHandler> getWebResponseHandler() {
        return mWebResponseHandlerClass;
    }

    public static void initAndroidNetworking(Context context, boolean isDebuggable) {
        if (isDebuggable) {
            Stetho.initializeWithDefaults((Context)context);
        }
        OkHttpClient.Builder mClientBuilder = new OkHttpClient.Builder().followRedirects(true).followSslRedirects(true).retryOnConnectionFailure(true).cache(null).connectTimeout(5L, TimeUnit.SECONDS).writeTimeout(5L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS);
        OkHttpClient.Builder builder = Tls12SocketFactory.enableTls12OnPreLollipop(mClientBuilder);
        if (isDebuggable) {
            builder.addNetworkInterceptor((Interceptor)new StethoInterceptor());
        }
        builder.readTimeout(1L, TimeUnit.MINUTES);
        builder.connectTimeout(10L, TimeUnit.SECONDS);
        OkHttpClient okHttpClient = builder.build();
        AndroidNetworking.initialize((Context)context, (OkHttpClient)okHttpClient);
        AndroidNetworking.setParserFactory((Parser.Factory)new GsonParserFactory());
    }
}

