package com.devdigital.networklib.task;

import com.devdigital.networklib.listener.ErrorListener;
import com.devdigital.networklib.listener.ResponseListener;

import org.json.JSONObject;

/**
 * @author Dhaval Patel
 * @version 1.0
 * @since 7 April 2017
 */
public class ObjectTask<Object> extends Task<Object> {

    public Task addOnSuccessListener(ResponseListener<Object> listener) {
        this.responseListener = listener;
        return this;
    }

    public Task addOnErrorListener(ErrorListener listener) {
        this.errorListener = listener;
        return this;
    }

    public ResponseListener<Object> getResponseListener() {
        return responseListener;
    }

    public ErrorListener getErrorListener() {
        return errorListener;
    }
}
