package com.devdigital.networklib.task;

import com.devdigital.networklib.listener.ErrorListener;
import com.devdigital.networklib.listener.ResponseListener;
import com.devdigital.networklib.model.NetworkStackResponse;

import org.json.JSONObject;

/**
 * @author Dhaval Patel
 * @version 1.0
 * @since 7 April 2017
 */
public class JSONObjectTask<JSONObject> extends Task<JSONObject> {

    public Task addOnSuccessListener(ResponseListener<JSONObject> listener) {
        this.responseListener = listener;
        return this;
    }

    public Task addOnErrorListener(ErrorListener listener) {
        this.errorListener = listener;
        return this;
    }

    public ResponseListener<JSONObject> getResponseListener() {
        return responseListener;
    }

    public ErrorListener getErrorListener() {
        return errorListener;
    }
}
