package com.devdigital.networklib.task;

import com.devdigital.networklib.listener.ErrorListener;
import com.devdigital.networklib.listener.ResponseListener;

import org.json.JSONArray;
import org.json.JSONObject;

/**
 * @author Dhaval Patel
 * @version 1.0
 * @since 7 April 2017
 */
public class JSONArrayTask<JSONArray> extends Task<JSONArray> {

    public Task addOnSuccessListener(ResponseListener<JSONArray> listener) {
        this.responseListener = listener;
        return this;
    }

    public Task addOnErrorListener(ErrorListener listener) {
        this.errorListener = listener;
        return this;
    }

    public ResponseListener<JSONArray> getResponseListener() {
        return responseListener;
    }

    public ErrorListener getErrorListener() {
        return errorListener;
    }
}
