/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.networklib.handler;

import android.text.TextUtils;
import android.util.Log;
import com.devdigital.networklib.NetworkController;
import com.devdigital.networklib.entity.BaseEntity;
import com.devdigital.networklib.exception.NetworkError;
import com.devdigital.networklib.exception.WebRequestException;
import com.devdigital.networklib.handler.BaseWebResponseHandler;
import com.devdigital.networklib.handler.IWebRequestExecutor;
import com.devdigital.networklib.handler.WebRequestBuilder;
import com.devdigital.networklib.json.JSONFactory;
import com.devdigital.networklib.listener.IWebResponseListener;
import com.devdigital.networklib.stack.AndroidNetworkingStack;
import com.devdigital.networklib.stack.INetworkStack;
import com.devdigital.networklib.stack.NetworkStackResponse;
import com.devdigital.networklib.utils.NetworkUtils;
import java.lang.reflect.Constructor;

public class WebRequestExecutor
implements IWebRequestExecutor,
IWebResponseListener {
    private static final Class<? extends INetworkStack> NETWORK_STACK_CLASS = AndroidNetworkingStack.class;
    private WebRequestBuilder mWebRequestBuilder;
    private IWebResponseListener mIWebResponseListener;
    private INetworkStack mNetworkStack;
    private BaseWebResponseHandler mWebResponseHandler;

    public WebRequestExecutor(WebRequestBuilder builder) {
        this.mWebRequestBuilder = builder;
        Class<? extends INetworkStack> networkStackCls = NETWORK_STACK_CLASS;
        if (this.mWebRequestBuilder.getNetworkStack() != null) {
            networkStackCls = this.mWebRequestBuilder.getNetworkStack();
        }
        this.mIWebResponseListener = this.mWebRequestBuilder.getResponseListener();
        this.mWebRequestBuilder.setResponseListener(this);
        try {
            Constructor<? extends INetworkStack> ctor = networkStackCls.getConstructor(WebRequestBuilder.class);
            this.mNetworkStack = ctor.newInstance(this.mWebRequestBuilder);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.mWebResponseHandler = NetworkController.getWebResponseHandler().newInstance();
            this.mWebResponseHandler.setWebRequestBuilder(this.mWebRequestBuilder);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void getAsync() {
        if (!NetworkUtils.isNetworkAvailable(this.mWebRequestBuilder.getContext()).booleanValue()) {
            NetworkStackResponse response = new NetworkStackResponse();
            response.setError(NetworkError.NO_NETWORK_ERROR);
            response.setSuccess(false);
            if (this.mWebRequestBuilder.isHandleError()) {
                this.mWebResponseHandler.handleNetworkError();
            }
            if (this.mIWebResponseListener != null) {
                this.mIWebResponseListener.onResponse(IWebResponseListener.ResponseStatus.HTTP_ERROR, response);
            }
            return;
        }
        if (this.mWebRequestBuilder.isDebug()) {
            Log.w((String)"Web_Service", (String)this.mWebRequestBuilder.toString());
        }
        this.mWebResponseHandler.showProgressDialog();
        this.mNetworkStack.getAsync();
    }

    @Override
    public BaseEntity get() throws WebRequestException {
        if (!NetworkUtils.isNetworkAvailable(this.mWebRequestBuilder.getContext()).booleanValue()) {
            this.mWebResponseHandler.handleNetworkError();
            throw new WebRequestException(NetworkError.NO_NETWORK_ERROR);
        }
        if (this.mWebRequestBuilder.isDebug()) {
            Log.w((String)"Web_Service", (String)this.mWebRequestBuilder.toString());
        }
        NetworkStackResponse networkResponse = this.mNetworkStack.getSync();
        Object entity = this.handleResponse(networkResponse, true);
        return (BaseEntity)entity;
    }

    @Override
    public void onResponse(IWebResponseListener.ResponseStatus responseStatus, Object result) {
        NetworkStackResponse networkResponse = (NetworkStackResponse)result;
        this.mWebResponseHandler.hideProgressDialog();
        try {
            this.handleResponse(networkResponse, false);
        }
        catch (WebRequestException e) {
            e.printStackTrace();
        }
    }

    private Object handleResponse(NetworkStackResponse networkResponse, boolean sync) throws WebRequestException {
        if (this.mWebRequestBuilder.isDebug()) {
            Log.i((String)"Response", (String)("HTTP Response is " + networkResponse.toString()));
        }
        Object baseEntity = null;
        if (networkResponse.isSuccess()) {
            boolean status;
            String response = networkResponse.getResult();
            boolean isJsonError = false;
            if (!TextUtils.isEmpty((CharSequence)response)) {
                try {
                    baseEntity = JSONFactory.getInstance().fromJson(response, this.mWebRequestBuilder.getEntityClass());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        baseEntity = JSONFactory.getInstance().fromJson(response, BaseEntity.class);
                    }
                    catch (Exception ex) {
                        isJsonError = true;
                        ex.printStackTrace();
                    }
                }
            }
            if (this.mWebRequestBuilder.isHandleError()) {
                status = this.mWebResponseHandler.handleResponse((BaseEntity)baseEntity);
            } else if (isJsonError) {
                status = false;
                networkResponse.setSuccess(false);
                networkResponse.setError(NetworkError.INVALID_JSON_ERROR);
                this.mWebResponseHandler.handleResponse(networkResponse);
            } else {
                status = BaseWebResponseHandler.isValidResponse((BaseEntity)baseEntity);
            }
            if (this.mIWebResponseListener != null) {
                this.mIWebResponseListener.onResponse(status ? IWebResponseListener.ResponseStatus.SUCCESS : IWebResponseListener.ResponseStatus.SERVER_ERROR, baseEntity);
            }
            if (isJsonError || sync && !status) {
                throw new WebRequestException(NetworkError.SERVER_ERROR);
            }
        } else {
            if (this.mWebRequestBuilder.isHandleError()) {
                this.mWebResponseHandler.handleResponse(networkResponse);
            }
            if (this.mIWebResponseListener != null) {
                this.mIWebResponseListener.onResponse(IWebResponseListener.ResponseStatus.HTTP_ERROR, networkResponse);
            }
            if (sync) {
                throw new WebRequestException(NetworkError.HTTP_ERROR);
            }
        }
        return baseEntity;
    }
}

