/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.networklib.stack;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.common.ANResponse;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.OkHttpResponseAndStringRequestListener;
import com.devdigital.networklib.exception.NetworkError;
import com.devdigital.networklib.handler.WebRequestBuilder;
import com.devdigital.networklib.listener.IWebResponseListener;
import com.devdigital.networklib.stack.INetworkStack;
import com.devdigital.networklib.stack.NetworkStackResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Response;

public class AndroidNetworkingStack
implements INetworkStack,
OkHttpResponseAndStringRequestListener {
    private WebRequestBuilder mWebRequestBuilder;

    public AndroidNetworkingStack(WebRequestBuilder fields) {
        this.mWebRequestBuilder = fields;
    }

    @Override
    public void getAsync() {
        ANRequest anRequest = this.getANRRequest();
        anRequest.getAsOkHttpResponseAndString((OkHttpResponseAndStringRequestListener)this);
    }

    @Override
    public NetworkStackResponse getSync() {
        ANRequest anRequest = this.getANRRequest();
        ANResponse anResponse = anRequest.executeForOkHttpResponse();
        NetworkStackResponse nResponse = anResponse.isSuccess() ? this.getSuccessResponse(anResponse.getOkHttpResponse()) : this.getErrorResponse(anResponse.getError());
        return nResponse;
    }

    private ANRequest getANRRequest() {
        ANRequest anRequest = this.mWebRequestBuilder.getRequestMethod() == WebRequestBuilder.RequestMethod.GET ? this.getGetANRRequest() : (this.mWebRequestBuilder.getRequestMethod() == WebRequestBuilder.RequestMethod.MULTI_PART ? this.getMultiPartANRRequest() : this.getPostANRRequest());
        return anRequest;
    }

    private ANRequest getPostANRRequest() {
        Object builder = this.mWebRequestBuilder.getRequestMethod() == WebRequestBuilder.RequestMethod.PUT ? AndroidNetworking.put((String)this.mWebRequestBuilder.getUrl()) : (this.mWebRequestBuilder.getRequestMethod() == WebRequestBuilder.RequestMethod.DELETE ? AndroidNetworking.delete((String)this.mWebRequestBuilder.getUrl()) : AndroidNetworking.post((String)this.mWebRequestBuilder.getUrl()));
        builder.addHeaders(this.mWebRequestBuilder.getHeader());
        if (this.mWebRequestBuilder.getRequestJSON() != null) {
            builder.addJSONObjectBody(this.mWebRequestBuilder.getRequestJSON());
        } else if (this.mWebRequestBuilder.getRequestParams() != null && !this.mWebRequestBuilder.getRequestParams().isEmpty()) {
            builder.addBodyParameter(this.getMapParam(this.mWebRequestBuilder.getRequestParams()));
        } else if (this.mWebRequestBuilder.getRequestBody() != null) {
            builder.addStringBody(this.mWebRequestBuilder.getRequestBody());
        }
        if (this.mWebRequestBuilder.getHeader() != null && this.mWebRequestBuilder.getHeader().containsKey("Content-Type")) {
            builder.setContentType(this.mWebRequestBuilder.getHeader().get("Content-Type").toString());
        }
        return builder.setTag((Object)this).build();
    }

    public ANRequest getMultiPartANRRequest() {
        ANRequest.MultiPartBuilder builder = AndroidNetworking.upload((String)this.mWebRequestBuilder.getUrl()).addHeaders(this.getMapParam(this.mWebRequestBuilder.getHeader()));
        if (this.mWebRequestBuilder.getRequestParams() != null) {
            builder.addMultipartParameter(this.getMapParam(this.mWebRequestBuilder.getRequestParams()));
        }
        if (this.mWebRequestBuilder.getMultipartFile() != null) {
            builder.addMultipartFile(this.mWebRequestBuilder.getMultipartFile());
        }
        if (this.mWebRequestBuilder.getHeader() != null && this.mWebRequestBuilder.getHeader().containsKey("Content-Type")) {
            builder.setContentType(this.mWebRequestBuilder.getHeader().get("Content-Type").toString());
        }
        return builder.setTag((Object)this).build();
    }

    private ANRequest getGetANRRequest() {
        ANRequest.GetRequestBuilder builder = AndroidNetworking.get((String)this.mWebRequestBuilder.getUrl()).addHeaders(this.getMapParam(this.mWebRequestBuilder.getHeader()));
        if (this.mWebRequestBuilder.getRequestParams() != null) {
            builder.addQueryParameter(this.getMapParam(this.mWebRequestBuilder.getRequestParams()));
        }
        return builder.setTag((Object)this).build();
    }

    public void onResponse(Response okHttpResponse, String response) {
        if (this.mWebRequestBuilder.getResponseListener() != null) {
            NetworkStackResponse nResponse = this.getSuccessResponse(okHttpResponse, response);
            this.mWebRequestBuilder.getResponseListener().onResponse(IWebResponseListener.ResponseStatus.SUCCESS, nResponse);
        }
    }

    public void onError(ANError anError) {
        NetworkStackResponse nResponse = this.getErrorResponse(anError);
        this.mWebRequestBuilder.getResponseListener().onResponse(IWebResponseListener.ResponseStatus.HTTP_ERROR, nResponse);
    }

    private NetworkStackResponse getSuccessResponse(Response response) {
        NetworkStackResponse nResponse = new NetworkStackResponse();
        nResponse.setSuccess(true);
        nResponse.setStatus(response.code());
        try {
            nResponse.setResult(response.body().source().readUtf8());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        nResponse.setHeaders(response.headers().toMultimap());
        return nResponse;
    }

    private NetworkStackResponse getSuccessResponse(Response response, String parsed) {
        NetworkStackResponse nResponse = new NetworkStackResponse();
        nResponse.setSuccess(true);
        nResponse.setStatus(response.code());
        nResponse.setResult(parsed);
        nResponse.setHeaders(response.headers().toMultimap());
        return nResponse;
    }

    private NetworkStackResponse getErrorResponse(ANError anError) {
        NetworkStackResponse nResponse = new NetworkStackResponse();
        nResponse.setSuccess(false);
        if (anError.getErrorCode() != 0) {
            nResponse.setStatus(anError.getErrorCode());
            nResponse.setResult(anError.getErrorBody());
            nResponse.setError(NetworkError.HTTP_ERROR);
        } else {
            nResponse.setResult(anError.getErrorDetail());
            switch (anError.getErrorDetail()) {
                case "connectionError": {
                    nResponse.setError(NetworkError.CONNECTION_ERROR);
                    break;
                }
                case "parseError": {
                    nResponse.setError(NetworkError.INVALID_JSON_ERROR);
                    break;
                }
                default: {
                    nResponse.setError(NetworkError.UNKNOWN_ERROR);
                }
            }
        }
        if (anError.getResponse() != null) {
            nResponse.setHeaders(anError.getResponse().headers().toMultimap());
        }
        return nResponse;
    }

    private Map<String, String> getMapParam(Map<String, Object> params) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            map.put(entry.getKey(), entry.getValue().toString());
        }
        return map;
    }
}

