package com.devdigital.networklib.json;

import com.google.gson.Gson;

/**
 * Factory class for json Parsing and Generation
 *
 * @author Dhaval Patel
 * @version 1.0
 * @since 22 November 2017
 */
public class JSONFactory {

    private static JSONFactory mJSONFactory;

    private Gson mGson;

    private JSONFactory(){
        mGson = new Gson();
    }

    public static JSONFactory getInstance(){
        if(mJSONFactory ==null){
            synchronized (JSONFactory.class){
                if(mJSONFactory ==null){
                    mJSONFactory = new JSONFactory();
                }
            }
        }
        return mJSONFactory;
    }

    public Object fromJson(String json, Class cls){
        return mGson.fromJson(json, cls);
    }

    public String getJson(Object object){
        return mGson.toJson(object);
    }

}
