/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.networklib.stack;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.common.ANResponse;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.OkHttpResponseListener;
import com.devdigital.networklib.handler.WebRequestBuilder;
import com.devdigital.networklib.listener.IWebResponseListener;
import com.devdigital.networklib.stack.INetworkStack;
import com.devdigital.networklib.stack.NetworkStackResponse;
import java.io.IOException;
import okhttp3.Response;

public class AndroidNetworkingStack
implements INetworkStack,
OkHttpResponseListener {
    private WebRequestBuilder mWebRequestBuilder;

    public AndroidNetworkingStack(WebRequestBuilder fields) {
        this.mWebRequestBuilder = fields;
    }

    @Override
    public void getAsync() {
        ANRequest anRequest = this.getANRRequest();
        anRequest.getAsOkHttpResponse((OkHttpResponseListener)this);
    }

    @Override
    public NetworkStackResponse getSync() {
        ANRequest anRequest = this.getANRRequest();
        ANResponse anResponse = anRequest.executeForOkHttpResponse();
        NetworkStackResponse nResponse = anResponse.isSuccess() ? this.getSuccessResponse(anResponse.getOkHttpResponse()) : this.getErrorResponse(anResponse.getError());
        return nResponse;
    }

    private ANRequest getANRRequest() {
        ANRequest anRequest = this.mWebRequestBuilder.getRequestMethod() == WebRequestBuilder.RequestMethod.GET ? this.getGetANRRequest() : (this.mWebRequestBuilder.getRequestMethod() == WebRequestBuilder.RequestMethod.MULTI_PART ? this.getMultiPartANRRequest() : this.getPostANRRequest());
        return anRequest;
    }

    private ANRequest getPostANRRequest() {
        Object builder = this.mWebRequestBuilder.getRequestMethod() == WebRequestBuilder.RequestMethod.PUT ? AndroidNetworking.put((String)this.mWebRequestBuilder.getUrl()) : (this.mWebRequestBuilder.getRequestMethod() == WebRequestBuilder.RequestMethod.DELETE ? AndroidNetworking.delete((String)this.mWebRequestBuilder.getUrl()) : AndroidNetworking.post((String)this.mWebRequestBuilder.getUrl()));
        builder.addHeaders(this.mWebRequestBuilder.getHeader());
        if (this.mWebRequestBuilder.getRequestJSON() != null) {
            builder.addJSONObjectBody(this.mWebRequestBuilder.getRequestJSON());
        } else if (this.mWebRequestBuilder.getRequestParams() != null) {
            builder.addBodyParameter(this.mWebRequestBuilder.getRequestParams());
        } else if (this.mWebRequestBuilder.getRequestBody() != null) {
            builder.addStringBody(this.mWebRequestBuilder.getRequestBody());
        }
        return builder.setTag((Object)this).build();
    }

    public ANRequest getMultiPartANRRequest() {
        ANRequest.MultiPartBuilder builder = AndroidNetworking.upload((String)this.mWebRequestBuilder.getUrl()).addHeaders(this.mWebRequestBuilder.getHeader());
        if (this.mWebRequestBuilder.getRequestParams() != null) {
            builder.addMultipartParameter(this.mWebRequestBuilder.getRequestParams());
        }
        if (this.mWebRequestBuilder.getMultipartFile() != null) {
            builder.addMultipartFile(this.mWebRequestBuilder.getMultipartFile());
        }
        return builder.setTag((Object)this).build();
    }

    private ANRequest getGetANRRequest() {
        ANRequest.GetRequestBuilder builder = AndroidNetworking.get((String)this.mWebRequestBuilder.getUrl()).addHeaders(this.mWebRequestBuilder.getHeader());
        if (this.mWebRequestBuilder.getRequestParams() != null) {
            builder.addQueryParameter(this.mWebRequestBuilder.getRequestParams());
        }
        return builder.setTag((Object)this).build();
    }

    public void onResponse(Response response) {
        if (this.mWebRequestBuilder.getResponseListener() != null) {
            NetworkStackResponse nResponse = this.getSuccessResponse(response);
            this.mWebRequestBuilder.getResponseListener().onResponse(IWebResponseListener.ResponseStatus.SUCCESS, nResponse);
        }
    }

    public void onError(ANError anError) {
        NetworkStackResponse nResponse = this.getErrorResponse(anError);
        this.mWebRequestBuilder.getResponseListener().onResponse(IWebResponseListener.ResponseStatus.HTTP_ERROR, nResponse);
    }

    private NetworkStackResponse getSuccessResponse(Response response) {
        NetworkStackResponse nResponse = new NetworkStackResponse();
        nResponse.setSuccess(true);
        nResponse.setStatus(response.code());
        try {
            nResponse.setResult(response.body().source().readUtf8());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        nResponse.setHeaders(response.headers().toMultimap());
        return nResponse;
    }

    private NetworkStackResponse getErrorResponse(ANError anError) {
        NetworkStackResponse nResponse = new NetworkStackResponse();
        nResponse.setSuccess(false);
        nResponse.setStatus(anError.getErrorCode());
        nResponse.setResult(anError.getErrorBody());
        if (anError.getResponse() != null) {
            nResponse.setHeaders(anError.getResponse().headers().toMultimap());
        }
        return nResponse;
    }
}

