/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.networklib.handler;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import com.devdigital.networklib.R;
import com.devdigital.networklib.entity.BaseEntity;
import com.devdigital.networklib.handler.StatusConstant;
import com.devdigital.networklib.handler.WebRequestBuilder;
import com.devdigital.networklib.stack.NetworkStackResponse;

public abstract class BaseWebResponseHandler {
    protected WebRequestBuilder mWebRequestBuilder;
    protected Object mProgressDialog;

    public void setWebRequestBuilder(WebRequestBuilder builder) {
        this.mWebRequestBuilder = builder;
    }

    public abstract boolean handleResponse(BaseEntity var1);

    public abstract boolean handleResponse(NetworkStackResponse var1);

    public void handleNetworkError() {
        Log.e((String)"NetworkError", (String)"handleNetworkError");
        this.showError(R.string.error_network_error);
    }

    public void showError(int resId) {
        Context context = this.mWebRequestBuilder.getContext();
        this.showError(context.getString(resId));
    }

    public void showError(String message) {
        if (this.mWebRequestBuilder.isShowErrorDialog()) {
            Context context = this.mWebRequestBuilder.getContext();
            if (!(context instanceof Activity)) {
                throw new RuntimeException("Require Activity Instance");
            }
            AlertDialog.Builder builder = Build.VERSION.SDK_INT >= 21 ? new AlertDialog.Builder(context, 16974374) : new AlertDialog.Builder(context);
            builder.setTitle(R.string.app_name).setMessage((CharSequence)message).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.cancel();
                    if (BaseWebResponseHandler.this.mWebRequestBuilder.getErrorDialogClickListener() != null) {
                        BaseWebResponseHandler.this.mWebRequestBuilder.getErrorDialogClickListener().onDialogClick();
                    }
                }
            }).setCancelable(false).setIcon(17301543).show();
        }
    }

    public static boolean isValidResponse(BaseEntity entity) {
        return entity != null && StatusConstant.SUCCESS.name().equalsIgnoreCase(entity.getStatus());
    }

    public void showProgressDialog() {
        if (!this.mWebRequestBuilder.isShowProgressDialog()) {
            return;
        }
        if (this.mWebRequestBuilder.getProgressView() != null) {
            this.mWebRequestBuilder.getProgressView().setVisibility(0);
        } else {
            String message = this.mWebRequestBuilder.getProgressMessage();
            if (message == null) {
                message = this.mWebRequestBuilder.getContext().getString(R.string.progress_dialog_message);
            }
            ProgressDialog progressDialog = new ProgressDialog(this.mWebRequestBuilder.getContext());
            progressDialog.setMessage((CharSequence)message);
            progressDialog.show();
            this.mProgressDialog = progressDialog;
        }
    }

    public void hideProgressDialog() {
        if (!this.mWebRequestBuilder.isShowProgressDialog()) {
            return;
        }
        if (this.mWebRequestBuilder.getProgressView() != null) {
            this.mWebRequestBuilder.getProgressView().setVisibility(8);
        } else {
            ProgressDialog progressDialog = (ProgressDialog)this.mProgressDialog;
            if (progressDialog != null) {
                progressDialog.hide();
            }
        }
    }
}

