/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.networklib.handler;

import android.content.Context;
import android.view.View;
import com.devdigital.networklib.entity.BaseEntity;
import com.devdigital.networklib.handler.WebRequestExecutor;
import com.devdigital.networklib.json.JSONFactory;
import com.devdigital.networklib.listener.IErrorDialogClickListener;
import com.devdigital.networklib.listener.IWebResponseListener;
import com.devdigital.networklib.stack.INetworkStack;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class WebRequestBuilder {
    private Context context;
    private String url;
    private RequestMethod requestMethod;
    private Map<String, Object> header;
    private JSONObject requestJSON;
    private Map<String, Object> requestParams;
    private Map<String, File> multipartFile;
    private String requestBody;
    private boolean handleError;
    private boolean showProgressDialog;
    private View progressView;
    private String progressMessage;
    private boolean showErrorDialog;
    private IWebResponseListener responseListener;
    private Class<? extends BaseEntity> entityClass;
    private Class<? extends INetworkStack> networkStack;
    private boolean debug;
    private IErrorDialogClickListener errorDialogClickListener;

    public WebRequestBuilder(Context context, String url) {
        this.context = context;
        this.requestMethod = RequestMethod.GET;
        this.requestParams = Collections.emptyMap();
        this.header = Collections.emptyMap();
        this.entityClass = BaseEntity.class;
        this.url = url;
    }

    public WebRequestBuilder setHeader(Map<String, Object> header) {
        this.header = header;
        return this;
    }

    public WebRequestBuilder setRequestMethod(RequestMethod requestMethod) {
        this.requestMethod = requestMethod;
        return this;
    }

    public WebRequestBuilder setRequestJSON(Map<String, Object> requestParams) {
        try {
            this.requestJSON = new JSONObject(JSONFactory.getInstance().getJson(requestParams));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public WebRequestBuilder setRequestParams(Map<String, Object> requestParams) {
        this.requestParams = requestParams;
        return this;
    }

    public WebRequestBuilder setHandleError(boolean handleError) {
        this.handleError = handleError;
        return this;
    }

    public WebRequestBuilder setShowProgressDialog(boolean showProgressDialog) {
        this.showProgressDialog = showProgressDialog;
        return this;
    }

    public WebRequestBuilder setShowErrorDialog(boolean showErrorDialog) {
        this.showErrorDialog = showErrorDialog;
        return this;
    }

    public WebRequestBuilder setResponseListener(IWebResponseListener responseListener) {
        this.responseListener = responseListener;
        return this;
    }

    public WebRequestBuilder setEntityClass(Class<? extends BaseEntity> entityClass) {
        this.entityClass = entityClass;
        return this;
    }

    public WebRequestBuilder setErrorDialogClickListener(IErrorDialogClickListener errorDialogClickListener) {
        this.errorDialogClickListener = errorDialogClickListener;
        return this;
    }

    public View getProgressView() {
        return this.progressView;
    }

    public WebRequestBuilder setProgressView(View progressView) {
        this.progressView = progressView;
        return this;
    }

    public String getProgressMessage() {
        return this.progressMessage;
    }

    public WebRequestBuilder setProgressMessage(String progressMessage) {
        this.progressMessage = progressMessage;
        return this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public WebRequestBuilder setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public Map<String, File> getMultipartFile() {
        return this.multipartFile;
    }

    public WebRequestBuilder setMultipartFile(Map<String, File> multipartFile) {
        this.multipartFile = multipartFile;
        return this;
    }

    public Context getContext() {
        return this.context;
    }

    public String getUrl() {
        return this.url;
    }

    public RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    public Map<String, Object> getHeader() {
        return this.header;
    }

    public JSONObject getRequestJSON() {
        return this.requestJSON;
    }

    public Map<String, Object> getRequestParams() {
        return this.requestParams;
    }

    public boolean isHandleError() {
        return this.handleError;
    }

    public boolean isShowProgressDialog() {
        return this.showProgressDialog;
    }

    public boolean isShowErrorDialog() {
        return this.showErrorDialog;
    }

    public IWebResponseListener getResponseListener() {
        return this.responseListener;
    }

    public Class<? extends BaseEntity> getEntityClass() {
        return this.entityClass;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public WebRequestBuilder setRequestBody(String requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public Class<? extends INetworkStack> getNetworkStack() {
        return this.networkStack;
    }

    public WebRequestBuilder setNetworkStack(Class<? extends INetworkStack> networkStack) {
        this.networkStack = networkStack;
        return this;
    }

    public IErrorDialogClickListener getErrorDialogClickListener() {
        return this.errorDialogClickListener;
    }

    public WebRequestExecutor build() {
        if (!this.url.startsWith("http")) {
            throw new RuntimeException("URL must be valid to perform any action");
        }
        return new WebRequestExecutor(this);
    }

    public String toString() {
        return "WebRequestBuilder{context=" + this.context + ", url='" + this.url + '\'' + ", requestMethod=" + (Object)((Object)this.requestMethod) + ", header=" + this.header + ", requestJSON=" + this.requestJSON + ", requestParams=" + this.requestParams + ", multipartFile=" + this.multipartFile + ", requestBody='" + this.requestBody + '\'' + ", handleError=" + this.handleError + ", showProgressDialog=" + this.showProgressDialog + ", progressView=" + this.progressView + ", progressMessage='" + this.progressMessage + '\'' + ", showErrorDialog=" + this.showErrorDialog + ", responseListener=" + this.responseListener + ", entityClass=" + this.entityClass + ", networkStack=" + this.networkStack + ", debug=" + this.debug + ", errorDialogClickListener=" + this.errorDialogClickListener + '}';
    }

    public static enum RequestMethod {
        GET,
        POST,
        PUT,
        DELETE,
        MULTI_PART;

    }
}

