/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.networklib;

import android.content.Context;
import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.gsonparserfactory.GsonParserFactory;
import com.androidnetworking.interfaces.Parser;
import com.devdigital.networklib.handler.BaseWebResponseHandler;
import com.facebook.stetho.Stetho;
import com.facebook.stetho.okhttp3.StethoInterceptor;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class NetworkController {
    private static Class<? extends BaseWebResponseHandler> mWebResponseHandlerClass;

    public static void setWebResponseHandler(Class<? extends BaseWebResponseHandler> cls) {
        mWebResponseHandlerClass = cls;
    }

    public static Class<? extends BaseWebResponseHandler> getWebResponseHandler() {
        return mWebResponseHandlerClass;
    }

    public static void initAndroidNetworking(Context context, boolean isDebuggable) {
        if (isDebuggable) {
            Stetho.initializeWithDefaults((Context)context);
        }
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder();
        if (isDebuggable) {
            builder.addNetworkInterceptor((Interceptor)new StethoInterceptor());
        }
        OkHttpClient okHttpClient = builder.build();
        AndroidNetworking.initialize((Context)context, (OkHttpClient)okHttpClient);
        AndroidNetworking.setParserFactory((Parser.Factory)new GsonParserFactory());
    }
}

