package com.devdigital.networklib.stack;

import com.devdigital.networklib.exception.NetworkError;

import java.util.List;
import java.util.Map;

/**
 * Model class to transfer Network Stack Response between classes
 *
 * @author Dhaval Patel
 * @version 1.0
 * @since 22 November 2017
 */
public class NetworkStackResponse {

    /**
     * HTTP status code
     */
    private int status;

    /**
     * It indicate not Error while executing request. There might be failure in json response.
     */
    private boolean success;

    /**
     * HTTP response
     */
    private String result;

    /**
     * HTTP response headers
     */
    private Map<String, List<String>> headers;

    /**
     * HTTP Error Status
     */
    private NetworkError error;

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public Map<String, List<String>> getHeaders() {
        return headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public NetworkError getError() {
        return error;
    }

    public void setError(NetworkError error) {
        this.error = error;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Override
    public String toString() {
        return "NetworkStackResponse{" +
                "status=" + status +
                ", success=" + success +
                ", result='" + result + '\'' +
                ", headers=" + headers +
                ", error=" + error +
                '}';
    }
}
