/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.networklib.stack;

import android.os.AsyncTask;
import com.devdigital.networklib.exception.NetworkError;
import com.devdigital.networklib.handler.WebRequestBuilder;
import com.devdigital.networklib.listener.IWebResponseListener;
import com.devdigital.networklib.stack.INetworkStack;
import com.devdigital.networklib.stack.NetworkStackResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;

public class HUrlConnectionStack
extends AsyncTask<Void, Void, String>
implements INetworkStack {
    private WebRequestBuilder mWebRequestBuilder;
    private int mStatusCode;
    private String mResponse;
    private Map<String, List<String>> mHeaders;
    private Exception mError;

    public HUrlConnectionStack(WebRequestBuilder fields) {
        this.mWebRequestBuilder = fields;
    }

    @Override
    public void getAsync() {
        this.execute(new Void[0]);
    }

    @Override
    public NetworkStackResponse getSync() {
        this.doInBackground(new Void[0]);
        NetworkStackResponse response = new NetworkStackResponse();
        response.setHeaders(this.mHeaders);
        response.setResult(this.mResponse);
        response.setStatus(this.mStatusCode);
        if (this.mError != null) {
            if (this.mError instanceof ConnectException || this.mError instanceof SocketException) {
                response.setError(NetworkError.CONNECTION_ERROR);
            } else {
                response.setError(NetworkError.UNKNOWN_ERROR);
            }
        } else {
            response.setSuccess(this.mStatusCode == 200);
        }
        return response;
    }

    protected String doInBackground(Void ... voids) {
        try {
            WebRequestBuilder.RequestMethod requestMethod = this.mWebRequestBuilder.getRequestMethod();
            URL obj = new URL(this.getURL());
            HttpURLConnection connection = (HttpURLConnection)obj.openConnection();
            this.setRequestHeaders(connection);
            connection.setRequestMethod(requestMethod.name());
            switch (requestMethod) {
                case POST: 
                case PUT: 
                case DELETE: {
                    connection.setDoOutput(true);
                    this.writePostBody(connection);
                }
            }
            this.mStatusCode = connection.getResponseCode();
            this.mResponse = this.mStatusCode == 200 ? this.getResponseBody(connection.getInputStream()) : this.getResponseBody(connection.getErrorStream());
            this.mHeaders = connection.getHeaderFields();
        }
        catch (Exception e) {
            this.mError = e;
        }
        return this.mResponse;
    }

    protected void onPostExecute(String s) {
        super.onPostExecute((Object)s);
        if (this.mWebRequestBuilder.getResponseListener() != null) {
            NetworkStackResponse response = new NetworkStackResponse();
            response.setStatus(this.mStatusCode);
            response.setHeaders(this.mHeaders);
            response.setResult(this.mResponse);
            if (this.mError != null) {
                if (this.mError instanceof ConnectException || this.mError instanceof SocketException) {
                    response.setError(NetworkError.CONNECTION_ERROR);
                } else {
                    response.setError(NetworkError.UNKNOWN_ERROR);
                }
            } else {
                response.setSuccess(this.mStatusCode == 200);
            }
            this.mWebRequestBuilder.getResponseListener().onResponse(this.mStatusCode == 200 ? IWebResponseListener.ResponseStatus.SUCCESS : IWebResponseListener.ResponseStatus.HTTP_ERROR, response);
        }
    }

    private String getURL() {
        if (this.mWebRequestBuilder.getRequestMethod() == WebRequestBuilder.RequestMethod.GET) {
            if (this.mWebRequestBuilder.getRequestParams() == null) {
                return this.mWebRequestBuilder.getUrl();
            }
            return this.mWebRequestBuilder.getUrl() + "?" + this.getBodyParams();
        }
        return this.mWebRequestBuilder.getUrl();
    }

    private void setRequestHeaders(HttpURLConnection connection) {
        if (this.mWebRequestBuilder.getHeader() != null) {
            for (Map.Entry<String, Object> entries : this.mWebRequestBuilder.getHeader().entrySet()) {
                if (entries.getKey() == null || entries.getValue() == null) continue;
                connection.setRequestProperty(entries.getKey(), entries.getValue().toString());
            }
        }
    }

    private void writePostBody(HttpURLConnection connection) throws IOException {
        OutputStreamWriter os = new OutputStreamWriter(connection.getOutputStream());
        if (this.mWebRequestBuilder.getRequestJSON() != null) {
            String json = this.mWebRequestBuilder.getRequestJSON().toString();
            os.write(json);
        } else if (this.mWebRequestBuilder.getRequestParams() != null) {
            os.write(this.getBodyParams());
        } else if (this.mWebRequestBuilder.getRequestBody() != null) {
            os.write(this.mWebRequestBuilder.getRequestBody());
        }
        os.flush();
        os.close();
    }

    private String getResponseBody(InputStream inputStream) throws IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder response = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }

    public static String encodeToUTF8(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return text;
        }
    }

    private String getBodyParams() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.mWebRequestBuilder.getRequestParams().entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(String.format("%s=%s", HUrlConnectionStack.encodeToUTF8(entry.getKey()), HUrlConnectionStack.encodeToUTF8(entry.getValue().toString())));
        }
        return sb.toString();
    }
}

