/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.networklib.handler;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.awesomedialog.blennersilva.awesomedialoglibrary.AwesomeErrorDialog;
import com.awesomedialog.blennersilva.awesomedialoglibrary.interfaces.Closure;
import com.devdigital.networklib.R;
import com.devdigital.networklib.entity.BaseEntity;
import com.devdigital.networklib.handler.StatusConstant;
import com.devdigital.networklib.handler.WebRequestBuilder;
import com.devdigital.networklib.stack.NetworkStackResponse;

public abstract class BaseWebResponseHandler {
    protected WebRequestBuilder mWebRequestBuilder;

    public void setWebRequestBuilder(WebRequestBuilder builder) {
        this.mWebRequestBuilder = builder;
    }

    public abstract boolean handleResponse(BaseEntity var1);

    public abstract boolean handleResponse(NetworkStackResponse var1);

    public void handleNetworkError() {
        Log.e((String)"NetworkError", (String)"handleNetworkError");
        this.showError(R.string.error_network_error);
    }

    public void showError(int resId) {
        Context context = this.mWebRequestBuilder.getContext();
        this.showError(context.getString(resId));
    }

    public void showError(String message) {
        if (this.mWebRequestBuilder.isShowErrorDialog()) {
            Context context = this.mWebRequestBuilder.getContext();
            if (!(context instanceof Activity)) {
                throw new RuntimeException("Require Activity Instance");
            }
            final AwesomeErrorDialog dialog = ((AwesomeErrorDialog)((AwesomeErrorDialog)((AwesomeErrorDialog)((AwesomeErrorDialog)((AwesomeErrorDialog)new AwesomeErrorDialog(context).setTitle(R.string.app_name)).setMessage((CharSequence)message)).setColoredCircle(R.color.dialogErrorBackgroundColor)).setDialogIconAndColor(R.drawable.ic_dialog_error, R.color.white)).setCancelable(true)).setButtonText(context.getString(R.string.dialog_ok_button)).setButtonBackgroundColor(R.color.dialogErrorBackgroundColor);
            dialog.setErrorButtonClick(new Closure(){

                public void exec() {
                    if (BaseWebResponseHandler.this.mWebRequestBuilder.getErrorDialogClickListener() != null) {
                        BaseWebResponseHandler.this.mWebRequestBuilder.getErrorDialogClickListener().onDialogClick();
                    }
                    dialog.hide();
                }
            });
            dialog.show();
        }
    }

    public static boolean isValidResponse(BaseEntity entity) {
        return entity != null && StatusConstant.SUCCESS.name().equalsIgnoreCase(entity.getStatus());
    }
}

