package com.devdigital.networklib.handler;

import com.devdigital.networklib.entity.BaseEntity;
import com.devdigital.networklib.exception.WebRequestException;

/**
 * Interface class for Web request executor.
 *
 * WebRequest Executor will be the Intermediator between UI and INetworkStack for WebService call.
 *
 * @author Dhaval Patel
 * @version 1.0
 * @since 21 November 2017
 */
public interface IWebRequestExecutor {

    /**
     * Used to Execute Request on Main UI thread
     */
    void getAsync();

    /**
     * Used to Execute Request on background or Service Thread
     */
    BaseEntity get()throws WebRequestException;
}
