package com.devdigital.networklib;

import android.content.Context;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.gsonparserfactory.GsonParserFactory;
import com.devdigital.networklib.handler.BaseWebResponseHandler;
import com.facebook.stetho.Stetho;
import com.facebook.stetho.okhttp3.StethoInterceptor;

import okhttp3.OkHttpClient;

/**
 * Network Lib module dependency injector
 *
 * @author Dhaval Patel
 * @version 1.0
 * @since 22 November 2017
 */
public class NetworkController {


    private static BaseWebResponseHandler mWebResponseHandler;

    public static void setWebResponseHandler(BaseWebResponseHandler webResponseHandler) {
        mWebResponseHandler = webResponseHandler;
    }

    public static BaseWebResponseHandler getWebResponseHandler() {
        return mWebResponseHandler;
    }

    /**
     * Call this method once from main {@link android.app.Application} call once to
     * initialize Stetho and AndroidNetworking library
     * <p>
     * To Use Stetho open  chrome://inspect/#devices in Chrome Browser
     *
     * @param context {@link Context} object
     */
    public static void initAndroidNetworking(Context context) {
        //Initialize Stetho
        Stetho.initializeWithDefaults(context);

        OkHttpClient okHttpClient = new OkHttpClient().newBuilder()
                //Intercept Network Request with Stetho
                .addNetworkInterceptor(new StethoInterceptor())
                .build();

        //Set OkHttpClient as HTTP stack
        AndroidNetworking.initialize(context, okHttpClient);
        //Add GSON as JSON Parser
        AndroidNetworking.setParserFactory(new GsonParserFactory());
    }

}
