/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.gallerylib.utils;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.media.MediaPlayer;
import android.net.Uri;
import java.io.File;
import life.knowledge4.videotrimmer.utils.PathToContentURI;

public class MediaUtils {
    public static long getVideoDuration(Context context, Uri uri) {
        String path = PathToContentURI.getPathFromUri((Context)context, (Uri)uri);
        return MediaUtils.getVideoDuration(context, path);
    }

    public static long getVideoDuration(Context context, String path) {
        File file = new File(path);
        if (file.exists() && file.length() > 0L) {
            try {
                MediaMetadataRetriever retriever = new MediaMetadataRetriever();
                retriever.setDataSource(context, Uri.fromFile((File)file));
                String time = retriever.extractMetadata(9);
                long timeInMillis = Long.parseLong(time);
                retriever.release();
                return timeInMillis;
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
                MediaPlayer mp = MediaPlayer.create((Context)context, (Uri)Uri.fromFile((File)file));
                int duration = mp.getDuration();
                mp.release();
                return duration;
            }
        }
        return -1L;
    }

    public static void playVideo(Context context, Uri uri) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(uri, "video/*");
        intent.addFlags(1);
        context.startActivity(intent);
    }

    public static Bitmap getVideoThumbnail(Context context, Uri uri) {
        return null;
    }
}

