/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.gallerylib;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.Fragment;
import com.devdigital.gallerylib.activities.ImagePickerActivity;

public class ImagePicker {
    public static final int REQUEST_PICK = 124;

    private ImagePicker() {
    }

    public static class Builder {
        private final Activity activity;
        private Fragment fragment;
        private boolean crop;
        private float cropX = 1.0f;
        private float cropY = 1.0f;
        private boolean cameraOnly;
        private boolean galleryOnly;
        private float maxFileSize = Float.MAX_VALUE;
        private String cameraImagePath;

        public Builder(Activity activity) {
            this.activity = activity;
        }

        public Builder(Fragment fragment) {
            this.activity = fragment.getActivity();
            this.fragment = fragment;
        }

        public Builder crop() {
            this.crop = true;
            return this;
        }

        public Builder cropSquare() {
            return this.cropAspectRatio(1.0f, 1.0f);
        }

        public Builder cropAspectRatio(float x, float y) {
            this.crop = true;
            this.cropX = x;
            this.cropY = y;
            return this;
        }

        public Builder cameraOnly() {
            this.cameraOnly = true;
            this.galleryOnly = false;
            return this;
        }

        public Builder galleryOnly() {
            this.cameraOnly = false;
            this.galleryOnly = true;
            return this;
        }

        public Builder maxFileSize(float sizeInKB) {
            this.maxFileSize = sizeInKB;
            return this;
        }

        public Builder cameraImagePath(String cameraImagePath) {
            this.cameraImagePath = cameraImagePath;
            return this;
        }

        public void start(int reqCode) {
            Intent intent = new Intent((Context)this.activity, ImagePickerActivity.class);
            intent.putExtra("CAMERA_ONLY", this.cameraOnly);
            intent.putExtra("GALLERY_ONLY", this.galleryOnly);
            intent.putExtra("FILE_SIZE_LIMIT", this.maxFileSize);
            intent.putExtra("CROP_IMAGE", this.crop);
            intent.putExtra("CROP_ASPECT_X", this.cropX);
            intent.putExtra("CROP_ASPECT_Y", this.cropY);
            intent.putExtra("CAMERA_IMAGE_FILE_PATH", this.cameraImagePath);
            if (this.fragment != null) {
                this.fragment.startActivityForResult(intent, reqCode);
            } else {
                this.activity.startActivityForResult(intent, reqCode);
            }
        }

        public void start() {
            this.start(124);
        }
    }
}

