package com.devdigital.gallerylib.utils;

import android.content.Intent;
import android.os.Build;
import android.os.Environment;

/**
 * Get Gallery Intent
 *
 * @author Dhaval Patel
 * @version 1.0
 * @since 07 June 2018
 */
public class IntentUtils {

    /**
     * @return Gallery Intent
     */
    public static Intent getGalleryIntent(boolean pickImage) {
        Intent intent;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            //In Mi devices Intent.ACTION_OPEN_DOCUMENT onActivityResult intent.getData is null.
            if (Build.MODEL.equalsIgnoreCase("Redmi 4")) {
                intent = new Intent(Intent.ACTION_PICK);
            } else {
                intent = new Intent(Intent.ACTION_OPEN_DOCUMENT);
            }
        } else {
            intent = new Intent(Intent.ACTION_PICK);
        }

        intent.addCategory(Intent.CATEGORY_OPENABLE);
        intent.setType(pickImage ? "image/*" : "video/*");
        return intent;
    }
}
