package com.devdigital.gallerylib.activities;

import android.app.ProgressDialog;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;

import com.devdigital.gallerylib.R;

import life.knowledge4.videotrimmer.K4LVideoTrimmer;
import life.knowledge4.videotrimmer.interfaces.OnK4LVideoListener;
import life.knowledge4.videotrimmer.interfaces.OnTrimVideoListener;

/**
 * Trim Video file,
 * Currently supporting mp4, mkv and 3gp file.
 *
 * @author Dhaval Patel
 * @version 1.0
 * @since 07 June 2018
 */
public class TrimmerActivity extends AppCompatActivity implements OnTrimVideoListener, OnK4LVideoListener {

    private K4LVideoTrimmer mVideoTrimmer;
    private ProgressDialog mProgressDialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mVideoTrimmer = new K4LVideoTrimmer(this);
        setContentView(mVideoTrimmer);

        Intent extraIntent = getIntent();
        //setting progressbar
        mProgressDialog = new ProgressDialog(this);
        mProgressDialog.setCancelable(false);
        mProgressDialog.setMessage(getString(R.string.trimming_progress));

        mVideoTrimmer.setMaxDuration(extraIntent.getIntExtra(VideoPickerActivity.EXTRA_DURATION_LIMIT, 60));
        mVideoTrimmer.setOnTrimVideoListener(this);
        mVideoTrimmer.setOnK4LVideoListener(this);
        mVideoTrimmer.setVideoURI(extraIntent.getData());
        mVideoTrimmer.setVideoInformationVisibility(true);
    }

    @Override
    public void onTrimStarted() {
        mProgressDialog.show();
    }

    @Override
    public void getResult(final Uri uri) {
        mProgressDialog.cancel();

        Intent intent = new Intent();
        intent.setData(uri);
        setResult(RESULT_OK, intent);
        finish();
    }

    @Override
    public void cancelAction() {
        mProgressDialog.cancel();
        mVideoTrimmer.destroy();

        Intent intent = new Intent();
        setResult(RESULT_CANCELED, intent);
        finish();
    }

    @Override
    public void onError(final String message) {
        cancelAction();
    }

    @Override
    public void onVideoPrepared() {

    }
}
