package com.devdigital.gallerylib;

import android.app.Activity;
import android.content.Intent;
import android.support.v4.app.Fragment;

import com.devdigital.gallerylib.activities.VideoPickerActivity;

/**
 * Builder class to pick video file from gallery
 *
 * @author Dhaval Patel
 * @version 1.0
 * @since 08 June 2018
 */
public class VideoPicker {

    public static final int REQUEST_PICK = 126;

    private VideoPicker(){

    }

    public static class Builder{

        private final Activity activity;
        private Fragment fragment;
        private boolean trim;
        private int durationLimit;
        private boolean cameraOnly;
        private boolean galleryOnly;
        private String cameraVideoPath;

        public Builder(Activity activity){
            this.activity = activity;
        }

        public Builder(Fragment fragment){
            this.activity = fragment.getActivity();
            this.fragment = fragment;
        }

        public Builder cameraOnly(){
            this.cameraOnly = true;
            this.galleryOnly = false;
            return this;
        }

        public Builder galleryOnly(){
            this.cameraOnly = false;
            this.galleryOnly = true;
            return this;
        }

        public Builder trim(){
            this.trim = true;
            return this;
        }

        public Builder durationLimit(int durationLimit){
            this.durationLimit = durationLimit;
            return this;
        }

        public Builder cameraVideoPath(String cameraVideoPath){
            this.cameraVideoPath = cameraVideoPath;
            return this;
        }

        public void start(int reqCode){
            Intent intent = new Intent(activity, VideoPickerActivity.class);

            intent.putExtra(VideoPickerActivity.EXTRAS_CAMERA_ONLY, cameraOnly);
            intent.putExtra(VideoPickerActivity.EXTRAS_GALLERY_ONLY, galleryOnly);
            intent.putExtra(VideoPickerActivity.EXTRA_DURATION_LIMIT, durationLimit);
            intent.putExtra(VideoPickerActivity.EXTRAS_TRIM_VIDEO, trim);
            intent.putExtra(VideoPickerActivity.EXTRAS_CAMERA_VIDEO_FILE_PATH, cameraVideoPath);

            if(fragment!=null){
                fragment.startActivityForResult(intent, reqCode);
            }else{
                activity.startActivityForResult(intent, reqCode);
            }
        }

        public void start(){
            start(REQUEST_PICK);
        }
    }

}
