/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.gallerylib.activities;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.content.FileProvider;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import com.devdigital.gallerylib.R;
import com.devdigital.gallerylib.activities.TrimmerActivity;
import com.devdigital.gallerylib.utils.FileUtil;
import com.devdigital.gallerylib.utils.IntentUtils;
import com.devdigital.gallerylib.utils.MediaUtils;
import com.devdigital.gallerylib.utils.PermissionManager;
import com.gun0912.tedpermission.PermissionListener;
import com.gun0912.tedpermission.TedPermission;
import java.io.File;
import java.util.ArrayList;

public class VideoPickerActivity
extends AppCompatActivity {
    private static final String TAG = VideoPickerActivity.class.getSimpleName();
    private static final int INTENT_CHOOSER_REQ_CODE = 1011;
    private static final int INTENT_TRIM_REQ_CODE = 1012;
    public static final String EXTRAS_CAMERA_ONLY = "CAMERA_ONLY";
    public static final String EXTRAS_GALLERY_ONLY = "GALLERY_ONLY";
    public static final String EXTRAS_TRIM_VIDEO = "TRIM_VIDEO";
    public static final String EXTRA_DURATION_LIMIT = "DURATION_LIMIT";
    public static final String EXTRAS_CAMERA_VIDEO_FILE_PATH = "CAMERA_VIDEO_FILE_PATH";
    private boolean mTrimVideo;
    private int mMaxTrimLength;
    private boolean mPickGalleryVideoOnly;
    private boolean mPickCameraVideoOnly;
    private File mCameraFile;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        this.mTrimVideo = intent.getBooleanExtra(EXTRAS_TRIM_VIDEO, false);
        this.mMaxTrimLength = intent.getIntExtra(EXTRA_DURATION_LIMIT, 0);
        this.mPickGalleryVideoOnly = intent.getBooleanExtra(EXTRAS_GALLERY_ONLY, false);
        this.mPickCameraVideoOnly = intent.getBooleanExtra(EXTRAS_CAMERA_ONLY, false);
        String cameraPath = intent.getStringExtra(EXTRAS_CAMERA_VIDEO_FILE_PATH);
        if (cameraPath != null) {
            this.mCameraFile = new File(cameraPath);
        }
        this.checkPermission();
    }

    private void checkPermission() {
        TedPermission.Builder builder = (TedPermission.Builder)((TedPermission.Builder)TedPermission.with((Context)this).setPermissionListener(new PermissionListener(){

            public void onPermissionGranted() {
                VideoPickerActivity.this.dispatchIntent();
            }

            public void onPermissionDenied(ArrayList<String> deniedPermissions) {
                VideoPickerActivity.this.finish();
            }
        })).setDeniedMessage(R.string.message_permission_denied);
        if (this.mPickGalleryVideoOnly) {
            builder.setPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"});
        } else {
            if (!PermissionManager.hasCameraPermission((Context)this)) {
                Log.e((String)TAG, (String)"Check if camera permission is set in manifest.!");
            }
            builder.setPermissions(new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"});
        }
        builder.check();
    }

    public void dispatchIntent() {
        Intent galleryIntent = IntentUtils.getGalleryIntent(false);
        Intent cameraIntent = this.getCameraIntent();
        if (this.mPickGalleryVideoOnly) {
            this.startActivityForResult(galleryIntent, 1011);
        } else if (this.mPickCameraVideoOnly) {
            this.startActivityForResult(cameraIntent, 1011);
        } else {
            Intent chooserIntent = Intent.createChooser((Intent)cameraIntent, (CharSequence)this.getString(R.string.txt_select));
            chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", (Parcelable[])new Intent[]{galleryIntent});
            this.startActivityForResult(chooserIntent, 1011);
        }
    }

    private Intent getCameraIntent() {
        Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
        if (this.mMaxTrimLength > 0) {
            intent.putExtra("android.intent.extra.durationLimit", this.mMaxTrimLength);
        }
        if (intent.resolveActivity(this.getPackageManager()) != null) {
            if (this.mCameraFile == null) {
                this.mCameraFile = FileUtil.getCameraFile(false);
            }
            if (this.mCameraFile != null) {
                if (Build.VERSION.SDK_INT >= 24) {
                    Uri photoURI = FileProvider.getUriForFile((Context)this, (String)(this.getPackageName() + this.getString(R.string.file_provider_authority_suffix)), (File)this.mCameraFile);
                    intent.putExtra("output", (Parcelable)photoURI);
                } else {
                    intent.putExtra("output", (Parcelable)Uri.fromFile((File)this.mCameraFile));
                }
                return intent;
            }
            this.onError();
        }
        return null;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1011) {
            if (resultCode == 0) {
                this.onError();
            } else if (data != null && data.getData() != null) {
                this.mCameraFile.delete();
                Uri uri = data.getData();
                long duration = MediaUtils.getVideoDuration((Context)this, uri);
                long durationInSec = duration / 1000L;
                if (this.mMaxTrimLength > 0 && durationInSec > (long)this.mMaxTrimLength || this.mTrimVideo) {
                    Intent intent = new Intent((Context)this, TrimmerActivity.class);
                    intent.putExtra(EXTRA_DURATION_LIMIT, this.mMaxTrimLength);
                    intent.setData(uri);
                    this.startActivityForResult(intent, 1012);
                } else {
                    this.onSuccess(uri);
                }
            } else {
                Uri uri = Uri.fromFile((File)this.mCameraFile);
                if (this.mTrimVideo) {
                    Intent intent = new Intent((Context)this, TrimmerActivity.class);
                    intent.setData(uri);
                    intent.putExtra(EXTRA_DURATION_LIMIT, this.mMaxTrimLength);
                    this.startActivityForResult(intent, 1012);
                } else {
                    this.onSuccess(uri);
                }
            }
        } else if (requestCode == 1012) {
            if (resultCode == -1) {
                this.mCameraFile.delete();
                Intent intent = new Intent();
                intent.setData(intent.getData());
                this.setResult(-1, intent);
                this.finish();
            } else {
                this.onError();
            }
        } else {
            this.onError();
        }
    }

    private void onSuccess(Uri data) {
        Intent intent = new Intent();
        intent.setData(data);
        this.setResult(-1, intent);
        this.finish();
    }

    private void onError() {
        if (this.mCameraFile != null) {
            this.mCameraFile.delete();
        }
        Intent intent = new Intent();
        this.setResult(0, intent);
        this.finish();
    }
}

