/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.gallerylib;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.Fragment;
import com.devdigital.gallerylib.activities.VideoPickerActivity;

public class VideoPicker {
    public static final int REQUEST_PICK = 126;

    private VideoPicker() {
    }

    public static class Builder {
        private final Activity activity;
        private Fragment fragment;
        private boolean trim;
        private int durationLimit;
        private boolean cameraOnly;
        private boolean galleryOnly;
        private String cameraVideoPath;

        public Builder(Activity activity) {
            this.activity = activity;
        }

        public Builder(Fragment fragment) {
            this.activity = fragment.getActivity();
            this.fragment = fragment;
        }

        public Builder cameraOnly() {
            this.cameraOnly = true;
            this.galleryOnly = false;
            return this;
        }

        public Builder galleryOnly() {
            this.cameraOnly = false;
            this.galleryOnly = true;
            return this;
        }

        public Builder trim() {
            this.trim = true;
            return this;
        }

        public Builder durationLimit(int durationLimit) {
            this.durationLimit = durationLimit;
            return this;
        }

        public Builder cameraVideoPath(String cameraVideoPath) {
            this.cameraVideoPath = cameraVideoPath;
            return this;
        }

        public void start(int reqCode) {
            Intent intent = new Intent((Context)this.activity, VideoPickerActivity.class);
            intent.putExtra("CAMERA_ONLY", this.cameraOnly);
            intent.putExtra("GALLERY_ONLY", this.galleryOnly);
            intent.putExtra("DURATION_LIMIT", this.durationLimit);
            intent.putExtra("TRIM_VIDEO", this.trim);
            intent.putExtra("CAMERA_VIDEO_FILE_PATH", this.cameraVideoPath);
            if (this.fragment != null) {
                this.fragment.startActivityForResult(intent, reqCode);
            } else {
                this.activity.startActivityForResult(intent, reqCode);
            }
        }

        public void start() {
            this.start(126);
        }
    }
}

