/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.gallerylib.activities;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.FileProvider;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import com.devdigital.gallerylib.R;
import com.devdigital.gallerylib.utils.FileUtil;
import com.devdigital.gallerylib.utils.ImageResizer;
import com.devdigital.gallerylib.utils.IntentUtils;
import com.devdigital.gallerylib.utils.PermissionManager;
import com.gun0912.tedpermission.PermissionListener;
import com.gun0912.tedpermission.TedPermission;
import com.yalantis.ucrop.UCrop;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public class ImagePickerActivity
extends AppCompatActivity {
    private static final String TAG = ImagePickerActivity.class.getSimpleName();
    private static final int INTENT_CHOOSER_REQ_CODE = 1001;
    public static final String EXTRAS_CROP_IMAGE = "CROP_IMAGE";
    public static final String EXTRAS_CAMERA_ONLY = "CAMERA_ONLY";
    public static final String EXTRAS_GALLERY_ONLY = "GALLERY_ONLY";
    public static final String EXTRAS_CROP_ASPECT_X = "CROP_ASPECT_X";
    public static final String EXTRAS_CROP_ASPECT_Y = "CROP_ASPECT_Y";
    public static final String EXTRAS_CAMERA_IMAGE_FILE_PATH = "CAMERA_IMAGE_FILE_PATH";
    public static final String EXTRA_MAX_FILE_SIZE = "FILE_SIZE_LIMIT";
    private File mCameraFile;
    private boolean mCropImage;
    private boolean mPickGalleryImageOnly;
    private boolean mPickCameraImageOnly;
    private ImageResizer mImageResizer;
    private float mCropAspectX;
    private float mCropAspectY;
    private File mCropImageFile;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        this.mCropImage = intent.getBooleanExtra(EXTRAS_CROP_IMAGE, false);
        this.mPickGalleryImageOnly = intent.getBooleanExtra(EXTRAS_GALLERY_ONLY, false);
        this.mPickCameraImageOnly = intent.getBooleanExtra(EXTRAS_CAMERA_ONLY, false);
        this.mCropAspectX = intent.getFloatExtra(EXTRAS_CROP_ASPECT_X, 1.0f);
        this.mCropAspectY = intent.getFloatExtra(EXTRAS_CROP_ASPECT_Y, 1.0f);
        float mFileSizeLimit = intent.getFloatExtra(EXTRA_MAX_FILE_SIZE, Float.MAX_VALUE);
        String cameraPath = intent.getStringExtra(EXTRAS_CAMERA_IMAGE_FILE_PATH);
        if (cameraPath != null) {
            this.mCameraFile = new File(cameraPath);
        }
        this.mImageResizer = new ImageResizer((Context)this, mFileSizeLimit);
        this.checkPermission();
    }

    private void checkPermission() {
        TedPermission.Builder builder = (TedPermission.Builder)((TedPermission.Builder)TedPermission.with((Context)this).setPermissionListener(new PermissionListener(){

            public void onPermissionGranted() {
                ImagePickerActivity.this.dispatchIntent();
            }

            public void onPermissionDenied(ArrayList<String> deniedPermissions) {
                ImagePickerActivity.this.finish();
            }
        })).setDeniedMessage(R.string.message_permission_denied);
        if (this.mPickGalleryImageOnly) {
            builder.setPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"});
        } else {
            if (!PermissionManager.hasCameraPermission((Context)this)) {
                Log.e((String)TAG, (String)"Check if camera permission is set in manifest.!");
            }
            builder.setPermissions(new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"});
        }
        builder.check();
    }

    public void dispatchIntent() {
        Intent galleryIntent = IntentUtils.getGalleryIntent(true);
        Intent cameraIntent = this.getCameraIntent();
        if (this.mPickGalleryImageOnly) {
            this.startActivityForResult(galleryIntent, 1001);
        } else if (this.mPickCameraImageOnly) {
            this.startActivityForResult(cameraIntent, 1001);
        } else {
            Intent chooserIntent = Intent.createChooser((Intent)cameraIntent, (CharSequence)this.getString(R.string.txt_select));
            chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", (Parcelable[])new Intent[]{galleryIntent});
            this.startActivityForResult(chooserIntent, 1001);
        }
    }

    private Intent getCameraIntent() {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (intent.resolveActivity(this.getPackageManager()) != null) {
            if (this.mCameraFile == null) {
                this.mCameraFile = FileUtil.getCameraFile(true);
            }
            if (this.mCameraFile != null) {
                if (Build.VERSION.SDK_INT >= 24) {
                    Uri photoURI = FileProvider.getUriForFile((Context)this, (String)(this.getPackageName() + this.getString(R.string.file_provider_authority_suffix)), (File)this.mCameraFile);
                    intent.putExtra("output", (Parcelable)photoURI);
                } else {
                    intent.putExtra("output", (Parcelable)Uri.fromFile((File)this.mCameraFile));
                }
                return intent;
            }
            this.onError();
        }
        return null;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1001) {
            if (resultCode == 0) {
                this.onError();
            } else if (data != null && data.getData() != null) {
                this.mCameraFile.delete();
                this.onSuccess(data.getData());
            } else {
                this.onSuccess(Uri.fromFile((File)this.mCameraFile));
            }
        } else if (requestCode == 69) {
            if (resultCode == -1) {
                this.mCameraFile.delete();
                Intent intent = new Intent();
                try {
                    intent.setData(this.mImageResizer.getResizedImage(UCrop.getOutput((Intent)data)));
                    this.setResult(-1, intent);
                    this.finish();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    this.onError();
                }
            } else {
                this.onError();
            }
        } else {
            this.onError();
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.onError();
    }

    private void onSuccess(Uri path) {
        if (this.mCropImage) {
            try {
                this.cropImage(path);
            }
            catch (IOException e) {
                e.printStackTrace();
                Intent intent = new Intent();
                this.setResult(0, intent);
                this.finish();
            }
        } else {
            Intent intent = new Intent();
            try {
                intent.setData(this.mImageResizer.getResizedImage(path));
                this.setResult(-1, intent);
                this.finish();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                this.onError();
            }
        }
    }

    private void onError() {
        if (this.mCameraFile != null) {
            this.mCameraFile.delete();
        }
        if (this.mCropImageFile != null) {
            this.mCropImageFile.delete();
        }
        Intent intent = new Intent();
        this.setResult(0, intent);
        this.finish();
    }

    private void cropImage(Uri path) throws IOException {
        UCrop.Options options = new UCrop.Options();
        options.setToolbarColor(ContextCompat.getColor((Context)this, (int)R.color.colorPrimary));
        options.setStatusBarColor(ContextCompat.getColor((Context)this, (int)R.color.colorPrimaryDark));
        this.mCropImageFile = FileUtil.getCameraFile(true);
        UCrop uCrop = UCrop.of((Uri)path, (Uri)Uri.fromFile((File)this.mCropImageFile)).withOptions(options);
        if (this.mCropAspectX > 0.0f && this.mCropAspectY > 0.0f) {
            uCrop.withAspectRatio(this.mCropAspectX, this.mCropAspectY);
        }
        try {
            uCrop.start((Activity)this, 69);
        }
        catch (ActivityNotFoundException ex) {
            Log.e((String)TAG, (String)"uCrop not specified in manifest file.");
            ex.printStackTrace();
            this.onError();
        }
    }
}

