package com.devdigital.gallerylib.utils;

import android.Manifest;
import android.content.Context;
import android.content.pm.PackageManager;

/**
 * Permission Utility
 *
 * @author Dhaval Patel
 * @version 1.0
 * @since 21 December 2017
 */
public class PermissionManager {

    public static boolean hasPermission(Context context, String permission){
        int result = context.checkCallingOrSelfPermission(permission);
        return result == PackageManager.PERMISSION_GRANTED;
    }

    /**
     * @param context Application Context
     * @return true if Read Storage permission is granted
     */
    public static boolean hasReadStoragePermission(Context context){
        return hasPermission(context, Manifest.permission.READ_EXTERNAL_STORAGE);
    }

    /**
     * @param context Application Context
     * @return true if camera permission is granted
     */
    public static boolean hasCameraPermission(Context context){
        return hasPermission(context, Manifest.permission.CAMERA);
    }

}
